/*
 * Decompiled with CFR 0.152.
 */
package fuzs.portablehole.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fuzs.portablehole.client.core.ClientModServices;
import fuzs.portablehole.core.particles.SparkleParticleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FXSparkle
extends TextureSheetParticle {
    private final boolean corrupt;
    public final boolean fake;
    public final int particle = 16;
    private final boolean slowdown = true;
    private final SpriteSet sprite;
    public static final ParticleRenderType NORMAL_RENDER = new ParticleRenderType(){

        public void m_6505_(BufferBuilder bufferBuilder, TextureManager textureManager) {
            FXSparkle.beginRenderCommon(bufferBuilder, textureManager);
        }

        public void m_6294_(Tesselator tessellator) {
            tessellator.m_85914_();
            FXSparkle.endRenderCommon();
        }

        public String toString() {
            return "botania:sparkle";
        }
    };

    public FXSparkle(ClientLevel world, double x, double y, double z, float size, float red, float green, float blue, int m, boolean fake, boolean noClip, boolean corrupt, SpriteSet sprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.f_107227_ = red;
        this.f_107228_ = green;
        this.f_107229_ = blue;
        this.f_107230_ = 0.75f;
        this.f_107226_ = 0.0f;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107663_ = (this.f_107223_.m_188501_() * 0.5f + 0.5f) * 0.2f * size;
        this.f_107225_ = 3 * m;
        this.m_107250_(0.01f, 0.01f);
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
        this.fake = fake;
        this.corrupt = corrupt;
        this.f_107219_ = !fake && !noClip;
        this.sprite = sprite;
        this.m_108339_(sprite);
    }

    public float m_5902_(float partialTicks) {
        return this.f_107663_ * (float)(this.f_107225_ - this.f_107224_ + 1) / (float)this.f_107225_;
    }

    public void m_5989_() {
        this.m_108339_(this.sprite);
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        this.f_107216_ -= 0.04 * (double)this.f_107226_;
        if (this.f_107219_ && !this.fake) {
            this.wiggleAround(this.f_107212_, (this.m_107277_().f_82289_ + this.m_107277_().f_82292_) / 2.0, this.f_107214_);
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        this.f_107215_ *= 0.9080000019073486;
        this.f_107216_ *= 0.9080000019073486;
        this.f_107217_ *= 0.9080000019073486;
        if (this.f_107218_) {
            this.f_107215_ *= (double)0.7f;
            this.f_107217_ *= (double)0.7f;
        }
        if (this.fake && this.f_107224_ > 1) {
            this.m_107274_();
        }
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return NORMAL_RENDER;
    }

    public void setGravity(float value) {
        this.f_107226_ = value;
    }

    private void wiggleAround(double x, double y, double z) {
        BlockPos blockpos = new BlockPos(x, y, z);
        Vec3 Vector3d = new Vec3(x - (double)blockpos.m_123341_(), y - (double)blockpos.m_123342_(), z - (double)blockpos.m_123343_());
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        Direction direction = Direction.UP;
        double d0 = Double.MAX_VALUE;
        for (Direction direction1 : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP}) {
            double d2;
            blockpos$mutable.m_122190_((Vec3i)blockpos).m_122173_(direction1);
            if (this.f_107208_.m_8055_((BlockPos)blockpos$mutable).m_60838_((BlockGetter)this.f_107208_, (BlockPos)blockpos$mutable)) continue;
            double d1 = Vector3d.m_82507_(direction1.m_122434_());
            double d = d2 = direction1.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - d1 : d1;
            if (!(d2 < d0)) continue;
            d0 = d2;
            direction = direction1;
        }
        float f = this.f_107223_.m_188501_() * 0.05f + 0.025f;
        float f1 = direction.m_122421_().m_122540_();
        float secondary = (this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 0.1f;
        float secondary2 = (this.f_107223_.m_188501_() - this.f_107223_.m_188501_()) * 0.1f;
        if (direction.m_122434_() == Direction.Axis.X) {
            this.f_107215_ = f1 * f;
            this.f_107216_ = secondary;
            this.f_107217_ = secondary2;
        } else if (direction.m_122434_() == Direction.Axis.Y) {
            this.f_107215_ = secondary;
            this.f_107216_ = f1 * f;
            this.f_107217_ = secondary2;
        } else if (direction.m_122434_() == Direction.Axis.Z) {
            this.f_107215_ = secondary;
            this.f_107216_ = secondary2;
            this.f_107217_ = f1 * f;
        }
    }

    private static void beginRenderCommon(BufferBuilder buffer, TextureManager textureManager) {
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        RenderSystem.m_69482_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)1);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118260_);
        AbstractTexture tex = textureManager.m_118506_(TextureAtlas.f_118260_);
        ClientModServices.ABSTRACTIONS.setFilterSave(tex, true, false);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
    }

    private static void endRenderCommon() {
        AbstractTexture tex = Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118260_);
        ClientModServices.ABSTRACTIONS.restoreLastFilter(tex);
        RenderSystem.m_69461_();
        RenderSystem.m_69458_((boolean)true);
    }

    public static class Factory
    implements ParticleProvider<SparkleParticleData> {
        private final SpriteSet sprite;

        public Factory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SparkleParticleData data, ClientLevel world, double x, double y, double z, double mx, double my, double mz) {
            return new FXSparkle(world, x, y, z, data.size, data.r, data.g, data.b, data.m, data.fake, data.noClip, data.corrupt, this.sprite);
        }
    }
}

