/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeSlotViewWrapper;
import thelm.packagedauto.api.IRecipeSlotsViewWrapper;
import thelm.packagedexcrafting.recipe.ElitePackageRecipeType;
import thelm.packagedexcrafting.recipe.UltimatePackageRecipeInfo;

public class UltimatePackageRecipeType
implements IPackageRecipeType {
    public static final UltimatePackageRecipeType INSTANCE = new UltimatePackageRecipeType();
    public static final ResourceLocation NAME = new ResourceLocation("packagedexcrafting:ultimate");
    public static final IntSet SLOTS;
    public static final List<ResourceLocation> CATEGORIES;
    public static final Vec3i COLOR;
    public static final Vec3i COLOR_DISABLED;

    protected UltimatePackageRecipeType() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)"recipe.packagedexcrafting.ultimate");
    }

    public MutableComponent getShortDisplayName() {
        return Component.m_237115_((String)"recipe.packagedexcrafting.ultimate.short");
    }

    public IPackageRecipeInfo getNewRecipeInfo() {
        return new UltimatePackageRecipeInfo();
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<ResourceLocation> getJEICategories() {
        return CATEGORIES;
    }

    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeSlotsViewWrapper recipeLayoutWrapper) {
        ITableRecipe recipe;
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        List slotViews = recipeLayoutWrapper.getRecipeSlotViews();
        Object object = recipeLayoutWrapper.getRecipe();
        if (object instanceof ITableRecipe && (recipe = (ITableRecipe)object).getTier() == 4) {
            int index = 0;
            int[] slotArray = SLOTS.toIntArray();
            for (IRecipeSlotViewWrapper slotView : slotViews) {
                if (slotView.isInput()) {
                    ItemStack stack;
                    Object displayed = slotView.getDisplayedIngredient().orElse(null);
                    if (displayed instanceof ItemStack && !(stack = (ItemStack)displayed).m_41619_()) {
                        map.put(slotArray[index], (Object)stack);
                    }
                    ++index;
                }
                if (index < 81) continue;
                break;
            }
            return map;
        }
        return ElitePackageRecipeType.INSTANCE.getRecipeTransferMap(recipeLayoutWrapper);
    }

    public Object getRepresentation() {
        return new ItemStack((ItemLike)ModBlocks.ULTIMATE_TABLE.get());
    }

    public Vec3i getSlotColor(int slot) {
        if (slot >= 81 && slot != 81 && slot < 90) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        CATEGORIES = ImmutableList.of((Object)new ResourceLocation("extendedcrafting:ultimate_crafting"), (Object)new ResourceLocation("extendedcrafting:elite_crafting"), (Object)new ResourceLocation("extendedcrafting:advanced_crafting"), (Object)new ResourceLocation("extendedcrafting:basic_crafting"));
        COLOR = new Vec3i(139, 139, 139);
        COLOR_DISABLED = new Vec3i(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        IntStream.range(0, 81).forEachOrdered(arg_0 -> ((IntSet)SLOTS).add(arg_0));
    }
}

