/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;
import thelm.packagedexcrafting.recipe.BasicPackageRecipeType;
import thelm.packagedexcrafting.recipe.ITablePackageRecipeInfo;

public class BasicPackageRecipeInfo
implements ITablePackageRecipeInfo {
    ITableRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    Container matrix = new SimpleContainer(9);
    ItemStack output;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    public void load(CompoundTag nbt) {
        this.input.clear();
        this.output = ItemStack.f_41583_;
        this.patterns.clear();
        Recipe recipe = MiscHelper.INSTANCE.getRecipeManager().m_44043_(new ResourceLocation(nbt.m_128461_("Recipe"))).orElse(null);
        ArrayList matrixList = new ArrayList();
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("Matrix", 10), matrixList);
        for (int i = 0; i < 9 && i < matrixList.size(); ++i) {
            this.matrix.m_6836_(i, (ItemStack)matrixList.get(i));
        }
        if (recipe instanceof ITableRecipe) {
            ITableRecipe tableRecipe;
            this.recipe = tableRecipe = (ITableRecipe)recipe;
            this.input.addAll(MiscHelper.INSTANCE.condenseStacks(this.matrix));
            this.output = this.recipe.m_5874_(this.matrix).m_41777_();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
                ++i;
            }
        }
    }

    public void save(CompoundTag nbt) {
        if (this.recipe != null) {
            nbt.m_128359_("Recipe", this.recipe.m_6423_().toString());
        }
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            matrixList.add(this.matrix.m_8020_(i));
        }
        ListTag matrixTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), matrixList);
        nbt.m_128365_("Matrix", (Tag)matrixTag);
    }

    public IPackageRecipeType getRecipeType() {
        return BasicPackageRecipeType.INSTANCE;
    }

    @Override
    public int getTier() {
        return 1;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    @Override
    public ITableRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public Container getMatrix() {
        return this.matrix;
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return this.recipe.m_7457_(this.matrix);
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, Level level) {
        this.recipe = null;
        this.input.clear();
        this.patterns.clear();
        int[] slotArray = BasicPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            toSet.m_41764_(1);
            this.matrix.m_6836_(i, toSet.m_41777_());
        }
        ITableRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().m_44015_((RecipeType)ModRecipeTypes.TABLE.get(), this.matrix, level).orElse(null);
        if (recipe != null) {
            this.recipe = recipe;
            this.input.addAll(MiscHelper.INSTANCE.condenseStacks(this.matrix));
            this.output = recipe.m_5874_(this.matrix).m_41777_();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
                ++i;
            }
            return;
        }
        this.matrix.m_6211_();
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = BasicPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            map.put(slotArray[i], (Object)this.matrix.m_8020_(i));
        }
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicPackageRecipeInfo) {
            BasicPackageRecipeInfo other = (BasicPackageRecipeInfo)obj;
            if (this.input.size() != other.input.size()) {
                return false;
            }
            for (int i = 0; i < this.input.size(); ++i) {
                if (ItemStack.m_41728_((ItemStack)this.input.get(i), (ItemStack)other.input.get(i))) continue;
                return false;
            }
            return this.recipe.equals(other.recipe);
        }
        return false;
    }

    public int hashCode() {
        Object[] toHash = new Object[2];
        Object[] inputArray = new Object[this.input.size()];
        for (int i = 0; i < this.input.size(); ++i) {
            ItemStack stack = this.input.get(i);
            inputArray[i] = new Object[]{stack.m_41720_(), stack.m_41613_(), stack.m_41783_()};
        }
        toHash[0] = this.recipe;
        toHash[1] = inputArray;
        return Arrays.deepHashCode(toHash);
    }
}

