/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.util.MiscHelper;

public class PackageRecipeList
implements IPackageRecipeList {
    private List<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();

    public PackageRecipeList(Level level, CompoundTag nbt) {
        this.load(level, nbt);
    }

    public PackageRecipeList(List<IPackageRecipeInfo> recipeList) {
        this.setRecipeList(recipeList);
    }

    @Override
    public List<IPackageRecipeInfo> getRecipeList() {
        return Collections.unmodifiableList(this.recipeList);
    }

    @Override
    public void setRecipeList(List<IPackageRecipeInfo> recipeList) {
        this.recipeList.clear();
        this.recipeList.addAll(recipeList);
    }

    @Override
    public void load(Level level, CompoundTag nbt) {
        this.recipeList.clear();
        if (nbt != null) {
            ListTag tagList = nbt.m_128437_("Recipes", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tag = tagList.m_128728_(i);
                IPackageRecipeInfo recipe = MiscHelper.INSTANCE.loadRecipe(tag);
                if (recipe == null) continue;
                this.recipeList.add(recipe);
            }
        }
    }

    @Override
    public void save(CompoundTag nbt) {
        ListTag tagList = new ListTag();
        for (IPackageRecipeInfo recipe : this.recipeList) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), recipe);
            tagList.add((Object)tag);
        }
        nbt.m_128365_("Recipes", (Tag)tagList);
    }
}

