/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.packagedauto.api.IMiscHelper;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.api.PackagedAutoApi;
import thelm.packagedauto.util.PackagePattern;

public class MiscHelper
implements IMiscHelper {
    public static final MiscHelper INSTANCE = new MiscHelper();
    private static final Cache<CompoundTag, IPackageRecipeInfo> RECIPE_CACHE = CacheBuilder.newBuilder().maximumSize(500L).build();
    private static final Logger LOGGER = LogManager.getLogger();
    private static MinecraftServer server;

    private MiscHelper() {
    }

    @Override
    public List<ItemStack> condenseStacks(Container container) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(container.m_6643_());
        for (int i = 0; i < container.m_6643_(); ++i) {
            stacks.add(container.m_8020_(i));
        }
        return this.condenseStacks((List<ItemStack>)stacks);
    }

    @Override
    public List<ItemStack> condenseStacks(IItemHandler itemHandler) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(itemHandler.getSlots());
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            stacks.add(itemHandler.getStackInSlot(i));
        }
        return this.condenseStacks((List<ItemStack>)stacks);
    }

    @Override
    public List<ItemStack> condenseStacks(ItemStack ... stacks) {
        return this.condenseStacks(List.of(stacks));
    }

    @Override
    public List<ItemStack> condenseStacks(Stream<ItemStack> stacks) {
        return this.condenseStacks(stacks.collect(Collectors.toList()));
    }

    @Override
    public List<ItemStack> condenseStacks(Iterable<ItemStack> stacks) {
        return this.condenseStacks(stacks instanceof List ? (List)stacks : Lists.newArrayList(stacks));
    }

    @Override
    public List<ItemStack> condenseStacks(List<ItemStack> stacks) {
        return this.condenseStacks(stacks, false);
    }

    @Override
    public List<ItemStack> condenseStacks(List<ItemStack> stacks, boolean ignoreStackSize) {
        Object2IntLinkedOpenCustomHashMap map = new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<Pair<Item, CompoundTag>>(){

            public int hashCode(Pair<Item, CompoundTag> o) {
                return Objects.hash(Item.m_41393_((Item)((Item)o.getLeft())), o.getRight());
            }

            public boolean equals(Pair<Item, CompoundTag> a, Pair<Item, CompoundTag> b) {
                return a.equals(b);
            }
        });
        for (ItemStack stack : stacks) {
            if (stack.m_41619_()) continue;
            Pair pair = Pair.of((Object)stack.m_41720_(), (Object)stack.m_41783_());
            if (!map.containsKey((Object)pair)) {
                map.put((Object)pair, 0);
            }
            map.addTo((Object)pair, stack.m_41613_());
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            int limit;
            int count;
            Pair pair = (Pair)entry.getKey();
            Item item = (Item)pair.getLeft();
            CompoundTag nbt = (CompoundTag)pair.getRight();
            if (ignoreStackSize) {
                list.add(new ItemStack((ItemLike)item, count));
                continue;
            }
            for (count = entry.getIntValue(); count > 0; count -= limit) {
                ItemStack toAdd = new ItemStack((ItemLike)item, 1);
                toAdd.m_41751_(nbt);
                limit = item.getMaxStackSize(toAdd);
                toAdd.m_41764_(Math.min(count, limit));
                list.add(toAdd);
            }
        }
        map.clear();
        return list;
    }

    @Override
    public ListTag saveAllItems(ListTag tagList, List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = list.get(i);
            boolean empty = stack.m_41619_();
            if (empty && i != list.size() - 1) continue;
            if (empty) {
                stack = new ItemStack((ItemLike)((Item)null));
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128344_("Index", (byte)i);
            stack.m_41739_(nbt);
            tagList.add((Object)nbt);
        }
        return tagList;
    }

    @Override
    public void loadAllItems(ListTag tagList, List<ItemStack> list) {
        list.clear();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag nbt = tagList.m_128728_(i);
            int j = nbt.m_128445_("Index") & 0xFF;
            while (j >= list.size()) {
                list.add(ItemStack.f_41583_);
            }
            if (j < 0) continue;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)nbt);
            list.set(j, stack.m_41619_() ? ItemStack.f_41583_ : stack);
        }
    }

    @Override
    public IPackagePattern getPattern(IPackageRecipeInfo recipeInfo, int index) {
        return new PackagePattern(recipeInfo, index);
    }

    @Override
    public List<ItemStack> getRemainingItems(Container container) {
        return this.getRemainingItems(IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((Container)container).m_8020_(arg_0)).collect(Collectors.toList()));
    }

    @Override
    public List<ItemStack> getRemainingItems(Container container, int minInclusive, int maxExclusive) {
        return this.getRemainingItems(IntStream.range(minInclusive, maxExclusive).mapToObj(arg_0 -> ((Container)container).m_8020_(arg_0)).collect(Collectors.toList()));
    }

    @Override
    public List<ItemStack> getRemainingItems(ItemStack ... stacks) {
        return this.getRemainingItems(List.of(stacks));
    }

    @Override
    public List<ItemStack> getRemainingItems(List<ItemStack> stacks) {
        NonNullList ret = NonNullList.m_122780_((int)stacks.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, (Object)this.getContainerItem(stacks.get(i)));
        }
        return ret;
    }

    @Override
    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41720_().hasCraftingRemainingItem(stack)) {
            if (!(stack = stack.m_41720_().getCraftingRemainingItem(stack)).m_41619_() && stack.m_41763_() && stack.m_41773_() > stack.m_41776_()) {
                return ItemStack.f_41583_;
            }
            return stack;
        }
        if (stack.m_41613_() > 1) {
            stack = stack.m_41777_();
            stack.m_41764_(stack.m_41613_() - 1);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack retStack = stack.m_41777_();
        retStack.m_41764_(stackSize);
        return retStack;
    }

    @Override
    public boolean isEmpty(IItemHandler itemHandler) {
        if (itemHandler == null || itemHandler.getSlots() == 0) {
            return false;
        }
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if (itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public CompoundTag saveRecipe(CompoundTag nbt, IPackageRecipeInfo recipe) {
        nbt.m_128359_("RecipeType", recipe.getRecipeType().getName().toString());
        recipe.save(nbt);
        return nbt;
    }

    @Override
    public IPackageRecipeInfo loadRecipe(CompoundTag nbt) {
        IPackageRecipeInfo recipe = (IPackageRecipeInfo)RECIPE_CACHE.getIfPresent((Object)nbt);
        if (recipe != null && recipe.isValid()) {
            return recipe;
        }
        IPackageRecipeType recipeType = PackagedAutoApi.instance().getRecipeType(new ResourceLocation(nbt.m_128461_("RecipeType")));
        if (recipeType != null) {
            recipe = recipeType.getNewRecipeInfo();
            recipe.load(nbt);
            RECIPE_CACHE.put((Object)nbt, (Object)recipe);
            if (recipe.isValid()) {
                return recipe;
            }
        }
        return null;
    }

    @Override
    public boolean removeExactSet(List<ItemStack> offered, List<ItemStack> required, boolean simulate) {
        List<ItemStack> condensedRequired = this.condenseStacks(required, true);
        List<ItemStack> condensedOffered = this.condenseStacks(offered, true);
        block0: for (ItemStack req : condensedRequired) {
            for (ItemStack offer : condensedOffered) {
                if (req.m_41613_() > offer.m_41613_() || req.m_41720_() != offer.m_41720_() || req.m_41782_() && !ItemStack.m_41658_((ItemStack)req, (ItemStack)offer)) continue;
                continue block0;
            }
            return false;
        }
        if (simulate) {
            return true;
        }
        for (ItemStack req : condensedRequired) {
            int count = req.m_41613_();
            for (ItemStack offer : offered) {
                if (offer.m_41619_() || req.m_41720_() != offer.m_41720_() || req.m_41782_() && !ItemStack.m_41658_((ItemStack)req, (ItemStack)offer)) continue;
                int toRemove = Math.min(count, offer.m_41613_());
                offer.m_41774_(toRemove);
                if ((count -= toRemove) != 0) continue;
            }
        }
        return true;
    }

    @Override
    public boolean arePatternsDisjoint(List<IPackagePattern> patternList) {
        ObjectRBTreeSet set = new ObjectRBTreeSet(Comparator.comparing(pair -> Pair.of((Object)ForgeRegistries.ITEMS.getKey((Object)((Item)pair.getLeft())), (Object)("" + pair.getRight()))));
        for (IPackagePattern pattern : patternList) {
            List<ItemStack> condensedInputs = this.condenseStacks(pattern.getInputs(), true);
            for (ItemStack stack : condensedInputs) {
                Pair toAdd = Pair.of((Object)stack.m_41720_(), (Object)stack.m_41783_());
                if (set.contains((Object)toAdd)) {
                    return false;
                }
                set.add((Object)toAdd);
            }
        }
        set.clear();
        return true;
    }

    @Override
    public ItemStack insertItem(IItemHandler itemHandler, ItemStack stack, boolean requireEmptySlot, boolean simulate) {
        if (itemHandler == null || stack.m_41619_()) {
            return stack;
        }
        if (!requireEmptySlot) {
            return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)simulate);
        }
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            if (!itemHandler.getStackInSlot(slot).m_41619_() || !(stack = itemHandler.insertItem(slot, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    public ItemStack fillVolume(BlockEntity blockEntity, Direction direction, ItemStack stack, boolean simulate) {
        IVolumePackageItem vPackage;
        if (blockEntity == null || stack.m_41619_()) {
            return stack;
        }
        Item item = stack.m_41720_();
        if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, direction)) {
            int simulateFilled;
            IVolumeType vType = vPackage.getVolumeType(stack);
            stack = stack.m_41777_();
            IVolumeStackWrapper vStack = vPackage.getVolumeStack(stack);
            while (!stack.m_41619_() && (simulateFilled = vType.fill((ICapabilityProvider)blockEntity, direction, vStack, true)) == vStack.getAmount()) {
                if (!simulate) {
                    vType.fill((ICapabilityProvider)blockEntity, direction, vStack, false);
                }
                stack.m_41774_(1);
                if (!stack.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return stack;
    }

    @Override
    public <T> Supplier<T> conditionalSupplier(BooleanSupplier conditionSupplier, Supplier<Supplier<T>> trueSupplier, Supplier<Supplier<T>> falseSupplier) {
        return () -> conditionSupplier.getAsBoolean() ? ((Supplier)trueSupplier.get()).get() : ((Supplier)falseSupplier.get()).get();
    }

    public void setServer(MinecraftServer server) {
        MiscHelper.server = server;
    }

    @Override
    public RecipeManager getRecipeManager() {
        return server != null ? server.m_129894_() : (RecipeManager)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().f_91073_.m_7465_());
    }
}

