/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class SidedItemHandlerWrapper<H extends IItemHandlerModifiable>
implements IItemHandlerModifiable {
    protected H itemHandler;
    protected Direction direction;

    public SidedItemHandlerWrapper(H itemHandler, Direction direction) {
        this.itemHandler = itemHandler;
        this.direction = direction;
    }

    public int getSlot(int slot, Direction direction) {
        int[] slots = this.getSlotsForDirection(direction);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public int getSlots() {
        return this.getSlotsForDirection(this.direction).length;
    }

    public ItemStack getStackInSlot(int slot) {
        int i = this.getSlot(slot, this.direction);
        return i == -1 ? ItemStack.f_41583_ : this.itemHandler.getStackInSlot(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int i = this.getSlot(slot, this.direction);
        return i == -1 || !this.canInsertItem(i, stack, this.direction) ? stack : this.itemHandler.insertItem(i, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int i = this.getSlot(slot, this.direction);
        return i == -1 || !this.canExtractItem(i, this.direction) ? ItemStack.f_41583_ : this.itemHandler.extractItem(i, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        int i = this.getSlot(slot, this.direction);
        return i == -1 ? 0 : this.itemHandler.getSlotLimit(i);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        int i = this.getSlot(slot, this.direction);
        return i == -1 ? false : this.itemHandler.isItemValid(i, stack);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int i = this.getSlot(slot, this.direction);
        if (i == -1) {
            this.itemHandler.setStackInSlot(i, stack);
        }
    }

    public abstract int[] getSlotsForDirection(Direction var1);

    public abstract boolean canInsertItem(int var1, ItemStack var2, Direction var3);

    public abstract boolean canExtractItem(int var1, Direction var2);
}

