/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.client.screen.AmountSpecifyingScreen;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.item.VolumePackageItem;
import thelm.packagedauto.menu.VolumeAmountSpecifyingMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.SetItemStackPacket;

public class VolumeAmountSpecifyingScreen
extends AmountSpecifyingScreen<VolumeAmountSpecifyingMenu> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/amount_specifying.png");
    private int containerSlot;
    private IVolumeStackWrapper stack;
    private int maxAmount;

    public VolumeAmountSpecifyingScreen(BaseScreen<?> parent, Inventory inventory, int containerSlot, IVolumeStackWrapper stack, int maxAmount) {
        super(parent, new VolumeAmountSpecifyingMenu(inventory, stack), inventory, (Component)Component.m_237115_((String)"gui.packagedauto.volume_amount_specifying"));
        this.f_97726_ = 172;
        this.f_97727_ = 99;
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.getAmount();
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    @Override
    protected int[] getIncrements() {
        return new int[]{100, 500, 1000};
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int amount = Mth.m_14045_((int)Integer.parseInt(this.amountField.m_94155_()), (int)0, (int)this.maxAmount);
            IVolumeStackWrapper newStack = this.stack.copy();
            newStack.setAmount(amount);
            PacketHandler.INSTANCE.sendToServer((Object)new SetItemStackPacket((short)this.containerSlot, VolumePackageItem.makeVolumePackage(newStack)));
            this.close();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

