/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.util.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public class DensityLerp
implements DensityFunction {
    public static final KeyDispatchDataCodec<DensityLerp> CODEC = KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("argument1").forGetter(d -> d.argument1), (App)DensityFunction.f_208218_.fieldOf("argument2").forGetter(d -> d.argument2), (App)DensityFunction.f_208218_.fieldOf("niveau").forGetter(d -> d.niveau), (App)Codec.DOUBLE.optionalFieldOf("mean", (Object)0.0).forGetter(d -> d.mean), (App)Codec.DOUBLE.optionalFieldOf("deviation", (Object)1.0).forGetter(d -> d.deviation)).apply((Applicative)instance, DensityLerp::new)));
    private final DensityFunction argument1;
    private final DensityFunction argument2;
    private final DensityFunction niveau;
    private final double mean;
    private final double deviation;

    public DensityLerp(DensityFunction argument1, DensityFunction argument2, DensityFunction niveau, double mean, double deviation) {
        this.argument1 = argument1;
        this.argument2 = argument2;
        this.niveau = niveau;
        this.mean = mean;
        this.deviation = deviation;
    }

    @Nonnull
    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC;
    }

    public double m_207386_(@Nonnull DensityFunction.FunctionContext context) {
        double a = this.argument1.m_207386_(context);
        double b = this.argument2.m_207386_(context);
        double n = Mth.m_14008_((double)this.niveau.m_207386_(context), (double)(this.mean - this.deviation), (double)(this.mean + this.deviation));
        return Mth.m_14139_((double)((n - this.mean) / (2.0 * this.deviation) + 0.5), (double)a, (double)b);
    }

    public void m_207362_(@Nonnull double[] array, @Nonnull DensityFunction.ContextProvider provider) {
        double[] a = new double[array.length];
        double[] b = new double[array.length];
        this.niveau.m_207362_(array, provider);
        this.argument1.m_207362_(a, provider);
        this.argument2.m_207362_(b, provider);
        for (int i = 0; i < array.length; ++i) {
            double n = Mth.m_14008_((double)array[i], (double)(this.mean - this.deviation), (double)(this.mean + this.deviation));
            array[i] = Mth.m_14139_((double)((n - this.mean) / (2.0 * this.deviation) + 0.5), (double)a[i], (double)b[i]);
        }
    }

    @Nonnull
    public DensityFunction m_207456_(@Nonnull DensityFunction.Visitor visitor) {
        return new DensityLerp(this.argument1.m_207456_(visitor), this.argument2.m_207456_(visitor), this.niveau.m_207456_(visitor), this.mean, this.deviation);
    }

    public double m_207402_() {
        return Math.min(this.argument1.m_207402_(), this.argument2.m_207402_());
    }

    public double m_207401_() {
        return Math.max(this.argument1.m_207401_(), this.argument2.m_207401_());
    }
}

