/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.data.recipes.extension;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.rune.RuneRitualRecipe;
import mythicbotany.rune.SpecialRuneInput;
import mythicbotany.rune.SpecialRuneOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.moddingx.libx.crafting.CraftingHelper2;
import org.moddingx.libx.datagen.provider.recipe.RecipeExtension;

public interface RuneRitualExtension
extends RecipeExtension {
    default public RuneRitualRecipeBuilder runeRitual(ItemLike centerRune) {
        return new RuneRitualRecipeBuilder(this, Ingredient.m_43929_((ItemLike[])new ItemLike[]{centerRune}));
    }

    default public RuneRitualRecipeBuilder runeRitual(TagKey<Item> centerRune) {
        return new RuneRitualRecipeBuilder(this, Ingredient.m_204132_(centerRune));
    }

    default public RuneRitualRecipeBuilder runeRitual(Ingredient centerRune) {
        return new RuneRitualRecipeBuilder(this, centerRune);
    }

    public static class RuneRitualRecipeBuilder {
        private final RecipeExtension ext;
        private final Ingredient centerRune;
        private final List<RuneRitualRecipe.RunePosition> runes = new ArrayList<RuneRitualRecipe.RunePosition>();
        private int manaCost = 0;
        private int tickTime = 200;
        private final List<Ingredient> inputs = new ArrayList<Ingredient>();
        private final List<ItemStack> outputs = new ArrayList<ItemStack>();
        @Nullable
        private SpecialRuneInput specialInput;
        @Nullable
        private SpecialRuneOutput specialOutput;

        private RuneRitualRecipeBuilder(RecipeExtension ext, Ingredient centerRune) {
            this.ext = ext;
            this.centerRune = centerRune;
        }

        public RuneRitualRecipeBuilder rune(ItemLike rune, int x, int z, boolean consume) {
            return this.rune(Ingredient.m_43929_((ItemLike[])new ItemLike[]{rune}), x, z, consume);
        }

        public RuneRitualRecipeBuilder rune(TagKey<Item> rune, int x, int z, boolean consume) {
            return this.rune(Ingredient.m_204132_(rune), x, z, consume);
        }

        public RuneRitualRecipeBuilder rune(Ingredient rune, int x, int z, boolean consume) {
            if (x < -5 || x > 5 || z < -5 || z > 5) {
                throw new IllegalStateException("Rune positions should not be more than 5 blocks away frm the central rune holder: (" + x + "," + z + ")");
            }
            this.runes.add(new RuneRitualRecipe.RunePosition(rune, x, z, consume));
            return this;
        }

        public RuneRitualRecipeBuilder rune4(ItemLike rune, int x, int z, boolean consume) {
            if (x == 0) {
                this.rune(rune, 0, -z, consume);
                this.rune(rune, 0, z, consume);
                this.rune(rune, -z, 0, consume);
                this.rune(rune, z, 0, consume);
            } else if (z == 0) {
                this.rune(rune, -x, 0, consume);
                this.rune(rune, x, 0, consume);
                this.rune(rune, 0, -x, consume);
                this.rune(rune, 0, x, consume);
            } else {
                this.rune(rune, -x, -z, consume);
                this.rune(rune, -x, z, consume);
                this.rune(rune, x, -z, consume);
                this.rune(rune, x, z, consume);
            }
            return this;
        }

        public RuneRitualRecipeBuilder rune4(TagKey<Item> rune, int x, int z, boolean consume) {
            if (x == 0) {
                this.rune(rune, 0, -z, consume);
                this.rune(rune, 0, z, consume);
                this.rune(rune, -z, 0, consume);
                this.rune(rune, z, 0, consume);
            } else if (z == 0) {
                this.rune(rune, -x, 0, consume);
                this.rune(rune, x, 0, consume);
                this.rune(rune, 0, -x, consume);
                this.rune(rune, 0, x, consume);
            } else {
                this.rune(rune, -x, -z, consume);
                this.rune(rune, -x, z, consume);
                this.rune(rune, x, -z, consume);
                this.rune(rune, x, z, consume);
            }
            return this;
        }

        public RuneRitualRecipeBuilder rune4(Ingredient rune, int x, int z, boolean consume) {
            if (x == 0) {
                this.rune(rune, 0, -z, consume);
                this.rune(rune, 0, z, consume);
                this.rune(rune, -z, 0, consume);
                this.rune(rune, z, 0, consume);
            } else if (z == 0) {
                this.rune(rune, -x, 0, consume);
                this.rune(rune, x, 0, consume);
                this.rune(rune, 0, -x, consume);
                this.rune(rune, 0, x, consume);
            } else {
                this.rune(rune, -x, -z, consume);
                this.rune(rune, -x, z, consume);
                this.rune(rune, x, -z, consume);
                this.rune(rune, x, z, consume);
            }
            return this;
        }

        public RuneRitualRecipeBuilder rune2(ItemLike rune, int x, int z, boolean consume) {
            this.rune(rune, -x, -z, consume);
            this.rune(rune, x, z, consume);
            return this;
        }

        public RuneRitualRecipeBuilder rune2(TagKey<Item> rune, int x, int z, boolean consume) {
            this.rune(rune, -x, -z, consume);
            this.rune(rune, x, z, consume);
            return this;
        }

        public RuneRitualRecipeBuilder rune2(Ingredient rune, int x, int z, boolean consume) {
            this.rune(rune, -x, -z, consume);
            this.rune(rune, x, z, consume);
            return this;
        }

        public RuneRitualRecipeBuilder rune(ItemLike rune, int x, int z) {
            return this.rune(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder rune(TagKey<Item> rune, int x, int z) {
            return this.rune(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder rune(Ingredient rune, int x, int z) {
            return this.rune(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder rune4(ItemLike rune, int x, int z) {
            return this.rune4(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder rune4(TagKey<Item> rune, int x, int z) {
            return this.rune4(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder rune4(Ingredient rune, int x, int z) {
            return this.rune4(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder rune2(ItemLike rune, int x, int z) {
            return this.rune2(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder rune2(TagKey<Item> rune, int x, int z) {
            return this.rune2(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder rune2(Ingredient rune, int x, int z) {
            return this.rune2(rune, x, z, false);
        }

        public RuneRitualRecipeBuilder mana(int manaCost) {
            this.manaCost = manaCost;
            return this;
        }

        public RuneRitualRecipeBuilder time(int tickTime) {
            this.tickTime = tickTime;
            return this;
        }

        public RuneRitualRecipeBuilder input(ItemLike input) {
            return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
        }

        public RuneRitualRecipeBuilder input(TagKey<Item> input) {
            return this.input(Ingredient.m_204132_(input));
        }

        public RuneRitualRecipeBuilder input(Ingredient input) {
            this.inputs.add(input);
            return this;
        }

        public RuneRitualRecipeBuilder output(ItemLike output) {
            return this.output(new ItemStack(output));
        }

        public RuneRitualRecipeBuilder output(ItemStack output) {
            this.outputs.add(output);
            return this;
        }

        public RuneRitualRecipeBuilder special(@Nullable SpecialRuneInput special) {
            this.specialInput = special;
            return this;
        }

        public RuneRitualRecipeBuilder special(@Nullable SpecialRuneOutput special) {
            this.specialOutput = special;
            return this;
        }

        public void build() {
            ResourceLocation rl = null;
            if (this.outputs.size() == 1) {
                rl = this.ext.provider().loc((ItemLike)this.outputs.get(0).m_41720_());
            } else if (this.specialOutput != null) {
                rl = this.specialOutput.id;
            }
            if (rl == null) {
                throw new IllegalStateException("Failed to infer recipe id for rune ritual recipe.");
            }
            this.build(rl);
        }

        public void build(ResourceLocation id) {
            this.ext.consumer().accept(new TheRecipe(new ResourceLocation(id.m_135827_(), "mythicbotany_rune_rituals/" + id.m_135815_()), this.centerRune, this.runes, this.manaCost, this.tickTime, this.inputs, this.outputs, this.specialInput, this.specialOutput));
        }

        private static class TheRecipe
        implements FinishedRecipe {
            private final ResourceLocation id;
            private final Ingredient centerRune;
            private final List<RuneRitualRecipe.RunePosition> runes;
            private final int manaCost;
            private final int tickTime;
            private final List<Ingredient> inputs;
            private final List<ItemStack> outputs;
            @Nullable
            private final SpecialRuneInput specialInput;
            @Nullable
            private final SpecialRuneOutput specialOutput;

            private TheRecipe(ResourceLocation id, Ingredient centerRune, List<RuneRitualRecipe.RunePosition> runes, int manaCost, int tickTime, List<Ingredient> inputs, List<ItemStack> outputs, @Nullable SpecialRuneInput specialInput, @Nullable SpecialRuneOutput specialOutput) {
                this.id = id;
                this.centerRune = centerRune;
                this.runes = ImmutableList.copyOf(runes);
                this.manaCost = manaCost;
                this.tickTime = tickTime;
                this.inputs = ImmutableList.copyOf(inputs);
                this.outputs = ImmutableList.copyOf(outputs);
                this.specialInput = specialInput;
                this.specialOutput = specialOutput;
            }

            @Nonnull
            public ResourceLocation m_6445_() {
                return this.id;
            }

            public void m_7917_(@Nonnull JsonObject json) {
                json.addProperty("group", "rune_rituals");
                json.add("center", this.centerRune.m_43942_());
                JsonArray runesJson = new JsonArray();
                this.runes.stream().map(rune -> {
                    JsonObject obj = new JsonObject();
                    obj.add("rune", rune.getRune().m_43942_());
                    obj.addProperty("x", (Number)rune.getX());
                    obj.addProperty("z", (Number)rune.getZ());
                    obj.addProperty("consume", Boolean.valueOf(rune.isConsumed()));
                    return obj;
                }).forEach(arg_0 -> ((JsonArray)runesJson).add(arg_0));
                json.add("runes", (JsonElement)runesJson);
                json.addProperty("mana", (Number)this.manaCost);
                json.addProperty("ticks", (Number)this.tickTime);
                JsonArray inputsJson = new JsonArray();
                this.inputs.stream().map(Ingredient::m_43942_).forEach(arg_0 -> ((JsonArray)inputsJson).add(arg_0));
                json.add("inputs", (JsonElement)inputsJson);
                JsonArray outputsJson = new JsonArray();
                this.outputs.stream().map(stack -> CraftingHelper2.serializeItemStack((ItemStack)stack, (boolean)true)).forEach(arg_0 -> ((JsonArray)outputsJson).add(arg_0));
                json.add("outputs", (JsonElement)outputsJson);
                if (this.specialInput != null) {
                    json.addProperty("special_input", this.specialInput.id.toString());
                }
                if (this.specialOutput != null) {
                    json.addProperty("special_output", this.specialOutput.id.toString());
                }
            }

            @Nonnull
            public RecipeSerializer<?> m_6637_() {
                return RuneRitualRecipe.Serializer.INSTANCE;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }
    }
}

