/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.voice;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Set;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.voice.VoiceConnection;
import mekanism.common.Mekanism;

public class VoiceServerManager {
    private final Set<VoiceConnection> connections = new ObjectOpenHashSet();
    private ServerSocket serverSocket;
    private Thread listenThread;
    private boolean foundLocal = false;
    private boolean running;

    public void start() {
        Mekanism.logger.info("VoiceServer: Starting up server...");
        try {
            this.running = true;
            this.serverSocket = new ServerSocket(MekanismAdditionsConfig.additions.voicePort.get());
            this.listenThread = new ListenThread();
            this.listenThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            Mekanism.logger.info("VoiceServer: Shutting down server...");
            try {
                this.listenThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.foundLocal = false;
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while shutting down server.", (Throwable)e);
        }
        this.running = false;
    }

    public void removeConnection(VoiceConnection connection) {
        this.connections.remove(connection);
    }

    public boolean isFoundLocal() {
        return this.foundLocal;
    }

    public void setFoundLocal(boolean found) {
        this.foundLocal = found;
    }

    public void sendToPlayers(short byteCount, byte[] audioData, VoiceConnection connection) {
        if (connection.getPlayer() == null) {
            return;
        }
        int channel = connection.getCurrentChannel();
        if (channel == 0) {
            return;
        }
        for (VoiceConnection iterConn : this.connections) {
            if (iterConn.getPlayer() == null || iterConn == connection || !iterConn.canListen(channel)) continue;
            iterConn.sendToPlayer(byteCount, audioData, connection);
        }
    }

    private class ListenThread
    extends Thread {
        private ListenThread() {
            super("VoiceServer Listen Thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (VoiceServerManager.this.running) {
                try {
                    Socket s = VoiceServerManager.this.serverSocket.accept();
                    VoiceConnection connection = new VoiceConnection(s);
                    connection.start();
                    VoiceServerManager.this.connections.add(connection);
                    Mekanism.logger.info("VoiceServer: Accepted new connection.");
                }
                catch (NullPointerException | SocketException s) {
                }
                catch (Exception e) {
                    Mekanism.logger.error("VoiceServer: Error while accepting connection.", (Throwable)e);
                }
            }
        }
    }
}

