/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.function.Supplier;
import mekanism.common.Mekanism;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="mekanism", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MekanismShaders {
    static final ShaderTracker MEKASUIT = new ShaderTracker();
    static final ShaderTracker SPS = new ShaderTracker();
    static final ShaderTracker FLAME = new ShaderTracker();

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
        MekanismShaders.registerShader(event, Mekanism.rl("rendertype_flame"), DefaultVertexFormat.f_85818_, FLAME);
        MekanismShaders.registerShader(event, Mekanism.rl("rendertype_mekasuit"), DefaultVertexFormat.f_85812_, MEKASUIT);
        MekanismShaders.registerShader(event, Mekanism.rl("rendertype_sps"), DefaultVertexFormat.f_85818_, SPS);
    }

    private static void registerShader(RegisterShadersEvent event, ResourceLocation shaderLocation, VertexFormat vertexFormat, ShaderTracker tracker) throws IOException {
        event.registerShader(new ShaderInstance((ResourceProvider)event.getResourceManager(), shaderLocation, vertexFormat), tracker::setInstance);
    }

    static class ShaderTracker
    implements Supplier<ShaderInstance> {
        private ShaderInstance instance;
        final RenderStateShard.ShaderStateShard shard = new RenderStateShard.ShaderStateShard((Supplier)this);

        private ShaderTracker() {
        }

        private void setInstance(ShaderInstance instance) {
            this.instance = instance;
        }

        @Override
        public ShaderInstance get() {
            return this.instance;
        }
    }
}

