/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.graph;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.graph.GuiGraph;
import net.minecraft.network.chat.Component;

public class GuiDoubleGraph
extends GuiGraph<DoubleList, DoubleGraphDataHandler> {
    private double currentScale = 10.0;
    private boolean fixedScale = false;

    public GuiDoubleGraph(IGuiWrapper gui, int x, int y, int width, int height, DoubleGraphDataHandler handler) {
        super(gui, x, y, width, height, new DoubleArrayList(), handler);
    }

    public void enableFixedScale(double scale) {
        this.fixedScale = true;
        this.currentScale = scale;
    }

    public void setMinScale(double minScale) {
        this.currentScale = minScale;
    }

    public void addData(double data) {
        if (((DoubleList)this.graphData).size() == this.f_93618_ - 2) {
            ((DoubleList)this.graphData).removeDouble(0);
        }
        ((DoubleList)this.graphData).add(data);
        if (!this.fixedScale) {
            DoubleListIterator doubleListIterator = ((DoubleList)this.graphData).iterator();
            while (doubleListIterator.hasNext()) {
                double i = (Double)doubleListIterator.next();
                if (!(i > this.currentScale)) continue;
                this.currentScale = i;
            }
        }
    }

    @Override
    protected int getRelativeHeight(int index, int height) {
        double data = Math.min(this.currentScale, ((DoubleList)this.graphData).getDouble(index));
        return MathUtils.clampToInt(data * (double)height / this.currentScale);
    }

    @Override
    protected Component getDataDisplay(int hoverIndex) {
        return ((DoubleGraphDataHandler)this.dataHandler).getDataDisplay(((DoubleList)this.graphData).getDouble(hoverIndex));
    }

    public static interface DoubleGraphDataHandler
    extends GuiGraph.GraphDataHandler {
        public Component getDataDisplay(double var1);
    }
}

