/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import io.ticticboom.mods.mm.util.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderer {
    public static final FluidRenderer INSTANCE = new FluidRenderer(1000, 16, 16, 16);
    private static final int TEX_WIDTH = 16;
    private static final int TEX_HEIGHT = 16;
    private int capacity;
    private final int width;
    private final int height;
    private final int minHeight;

    public FluidRenderer(int capacity, int width, int height, int minHeight) {
        this.capacity = capacity;
        this.width = width;
        this.height = height;
        this.minHeight = minHeight;
    }

    public void render(PoseStack matrixStack, int xPosition, int yPosition, FluidStack stack, int height) {
        RenderSystem.m_69478_();
        RenderSystem.m_69482_();
        this.drawFluid(matrixStack, xPosition, yPosition, stack, height);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69465_();
        RenderSystem.m_69461_();
    }

    private void drawFluid(PoseStack matrixStack, int xPosition, int yPosition, FluidStack stack, int height) {
        if (stack == null) {
            return;
        }
        Fluid fluid = stack.getFluid();
        if (fluid == null) {
            return;
        }
        TextureAtlasSprite fluidStillSprite = this.getStillFluidSprite(stack);
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        int fluidColor = attributes.getTintColor(stack);
        this.drawTiledSprite(matrixStack, xPosition, yPosition, this.width, height, fluidColor, height, fluidStillSprite);
    }

    private void drawTiledSprite(PoseStack matrixStack, int xPosition, int yPosition, int width, int height, int color, int scaledAmount, TextureAtlasSprite sprite) {
        RenderHelper.useTexture(InventoryMenu.f_39692_);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        FluidRenderer.setGLColorFromInt(color);
        int xTileCount = width / 16;
        int xRemainder = height - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = yPosition + height;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int w = xTile == xTileCount ? xRemainder : 16;
                int h = yTile == yTileCount ? yRemainder : 16;
                int x = xPosition + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (w <= 0 || h <= 0) continue;
                int maskTop = 16 - h;
                int maskRight = 16 - w;
                this.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100);
            }
        }
    }

    private void drawTextureWithMasking(Matrix4f matrix, int x, int y, TextureAtlasSprite sprite, int maskTop, int maskRight, int z) {
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, (float)x, (float)(y + 16), (float)z).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + 16 - maskRight), (float)(y + 16), (float)z).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + 16 - maskRight), (float)(y + maskTop), (float)z).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x, (float)(y + maskTop), (float)z).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    private static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    private TextureAtlasSprite getStillFluidSprite(FluidStack stack) {
        Minecraft minecraft = Minecraft.m_91087_();
        Fluid fluid = stack.getFluid();
        IClientFluidTypeExtensions attributes = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = attributes.getStillTexture(stack);
        return (TextureAtlasSprite)minecraft.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }
}

