/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.thread;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.block.ControllerBlock;
import io.ticticboom.mods.mm.ports.base.IPortBlock;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureGenThread
extends Thread {
    private final BlockPos start;
    private final BlockPos end;
    private final Level level;
    private List<List<String>> layout = new ArrayList<List<String>>();
    private Map<String, JsonObject> key = new HashMap<String, JsonObject>();
    private int counter = 64;

    public StructureGenThread(BlockPos start, BlockPos end, Level level) {
        this.start = start;
        this.end = end;
        this.level = level;
    }

    private String increment() {
        ++this.counter;
        if ((char)this.counter == ':' || (char)this.counter == 'C') {
            ++this.counter;
        }
        return Character.toString((char)this.counter);
    }

    private String setPort(IPortBlock port, BlockPos pos) {
        for (Map.Entry<String, JsonObject> entry : this.key.entrySet()) {
            if (!entry.getValue().get("type").getAsString().equals("mm:port") || !entry.getValue().get("port").getAsString().equals(port.model().port().toString()) || entry.getValue().get("input").getAsBoolean() != port.model().input()) continue;
            return entry.getKey();
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", Ref.StructureParts.PORT.toString());
        json.addProperty("port", port.model().port().toString());
        json.addProperty("input", Boolean.valueOf(port.model().input()));
        String chara = this.increment();
        this.key.put(chara, json);
        return chara;
    }

    private String setBlock(Block block, BlockPos pos) {
        ResourceLocation blockResourceLocation = ForgeRegistries.BLOCKS.getKey((Object)block);
        for (Map.Entry<String, JsonObject> entry : this.key.entrySet()) {
            if (!entry.getValue().get("type").getAsString().equals("mm:block") || !entry.getValue().get("block").getAsString().equals(blockResourceLocation.toString())) continue;
            return entry.getKey();
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", Ref.StructureParts.BLOCK.toString());
        json.addProperty("block", blockResourceLocation.toString());
        String chara = this.increment();
        this.key.put(chara, json);
        return chara;
    }

    private void save(String controllerId) {
        JsonArray layoutJson = new JsonArray();
        Collections.reverse(this.layout);
        for (List<String> list : this.layout) {
            JsonArray jsonArray = new JsonArray();
            for (String string : list) {
                jsonArray.add(string);
            }
            layoutJson.add((JsonElement)jsonArray);
        }
        JsonObject keyJson = new JsonObject();
        for (Map.Entry<String, JsonObject> entry : this.key.entrySet()) {
            keyJson.add(entry.getKey(), (JsonElement)entry.getValue());
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("controllerId", controllerId);
        jsonObject.add("name", (JsonElement)new JsonObject());
        jsonObject.add("layout", (JsonElement)layoutJson);
        jsonObject.add("key", (JsonElement)keyJson);
        Path path = FMLPaths.GAMEDIR.get().resolve("mm_generated");
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            Files.writeString(path.resolve(new Date().getTime() + ".json"), (CharSequence)jsonObject.toString(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        String controllerId = "";
        int startX = Math.min(this.start.m_123341_(), this.end.m_123341_());
        int startZ = Math.min(this.start.m_123343_(), this.end.m_123343_());
        int startY = Math.min(this.start.m_123342_(), this.end.m_123342_());
        int endX = Math.max(this.start.m_123341_(), this.end.m_123341_());
        int endZ = Math.max(this.start.m_123343_(), this.end.m_123343_());
        int endY = Math.max(this.start.m_123342_(), this.end.m_123342_());
        for (int y = startY; y <= endY; ++y) {
            ArrayList<String> layer = new ArrayList<String>();
            for (int z = startZ; z <= endZ; ++z) {
                StringBuilder row = new StringBuilder();
                for (int x = startX; x <= endX; ++x) {
                    Object id;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.level.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (block instanceof IPortBlock) {
                        IPortBlock port = (IPortBlock)block;
                        id = this.setPort(port, pos);
                        row.append((String)id);
                        continue;
                    }
                    id = state.m_60734_();
                    if (id instanceof ControllerBlock) {
                        ControllerBlock controller = (ControllerBlock)((Object)id);
                        controllerId = controller.model().id().toString();
                        row.append("C");
                        continue;
                    }
                    if (!state.m_60795_()) {
                        id = this.setBlock(state.m_60734_(), pos);
                        row.append((String)id);
                        continue;
                    }
                    row.append(" ");
                }
                layer.add(row.toString());
            }
            this.layout.add(layer);
        }
        this.save(controllerId);
    }
}

