/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup.reload;

import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import io.ticticboom.mods.mm.compat.kube.MMEvents;
import io.ticticboom.mods.mm.compat.kube.recipe.RecipeEventHandler;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.setup.model.RecipeModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RecipeManager
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceLocation, RecipeModel> REGISTRY = new HashMap<ResourceLocation, RecipeModel>();

    public RecipeManager() {
        super(MMRegistries.GSON, "mm/processes");
    }

    @SubscribeEvent
    public static void register(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RecipeManager());
    }

    protected void apply(Map<ResourceLocation, JsonElement> entries, ResourceManager manager, ProfilerFiller profiler) {
        REGISTRY.clear();
        if (ModList.get().isLoaded("kubejs")) {
            MMEvents.RECIPE.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new RecipeEventHandler());
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry : entries.entrySet()) {
            REGISTRY.put(entry.getKey(), RecipeModel.parse(entry.getKey(), entry.getValue().getAsJsonObject()));
        }
    }
}

