/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.structure.IConfiguredStructurePart;
import io.ticticboom.mods.mm.structure.MMStructurePart;
import io.ticticboom.mods.mm.structure.transformers.MMStructureTransform;
import io.ticticboom.mods.mm.util.Deferred;
import io.ticticboom.mods.mm.util.ParseHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record StructureModel(ResourceLocation id, Component name, ResourceLocation controllerId, List<List<String>> layout, Map<String, IdentifiedStructurePart> key, List<PlacedStructurePart> flattened, List<TypedTransformedParts> transformed) {
    public static StructureModel parse(ResourceLocation id, JsonObject json) {
        ResourceLocation controllerId = ResourceLocation.m_135820_((String)json.get("controllerId").getAsString());
        Component name = ParseHelper.parseName(json.get("name").getAsJsonObject(), "");
        List<List<String>> layout = StructureModel.parseLayout(json.get("layout"));
        Collections.reverse(layout);
        Map<String, IdentifiedStructurePart> key = StructureModel.parseKey(json.get("key").getAsJsonObject());
        List<PlacedStructurePart> flattened = StructureModel.parseFlattened(key, layout);
        List<TypedTransformedParts> transformed = StructureModel.applyTransforms(flattened);
        return new StructureModel(id, name, controllerId, layout, key, flattened, transformed);
    }

    private static List<List<String>> parseLayout(JsonElement elem) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (JsonElement layer : elem.getAsJsonArray()) {
            ArrayList<String> inner = new ArrayList<String>();
            for (JsonElement row : layer.getAsJsonArray()) {
                inner.add(row.getAsString());
            }
            result.add(inner);
        }
        return result;
    }

    private static Map<String, IdentifiedStructurePart> parseKey(JsonObject json) {
        HashMap<String, IdentifiedStructurePart> result = new HashMap<String, IdentifiedStructurePart>();
        for (String s : json.keySet()) {
            if (s.equals("C") || s.equals(" ")) continue;
            JsonObject obj = json.get(s).getAsJsonObject();
            ResourceLocation partId = ResourceLocation.m_135820_((String)obj.get("type").getAsString());
            MMStructurePart structurePart = (MMStructurePart)MMRegistries.STRUCTURE_PARTS.get().getValue(partId);
            if (structurePart == null) {
                Ref.LOG.error("structure Part id: {} does not exist in registries", (Object)partId);
            }
            IConfiguredStructurePart config = structurePart.parse(obj);
            result.put(s, new IdentifiedStructurePart(partId, config));
        }
        return result;
    }

    private static List<PlacedStructurePart> parseFlattened(Map<String, IdentifiedStructurePart> key, List<List<String>> layout) {
        BlockPos controllerPos = StructureModel.findControllerPos(layout);
        ArrayList<PlacedStructurePart> result = new ArrayList<PlacedStructurePart>();
        StructureModel.runWithCoords(layout, x -> {
            if (x.character.charValue() == 'C' || x.character.charValue() == ' ') {
                return;
            }
            result.add(StructureModel.placeStructurePart(key, x, controllerPos));
        });
        return result;
    }

    private static BlockPos findControllerPos(List<List<String>> layout) {
        Deferred controllerPos = new Deferred();
        StructureModel.runWithCoords(layout, x -> {
            if (x.character.charValue() == 'C') {
                controllerPos.set(x.pos);
            }
        });
        return (BlockPos)controllerPos.data;
    }

    private static PlacedStructurePart placeStructurePart(Map<String, IdentifiedStructurePart> key, AnnotatedPos anPos, BlockPos controllerPos) {
        BlockPos relativePos = anPos.pos.m_121996_((Vec3i)controllerPos);
        IdentifiedStructurePart config = key.get(anPos.character.toString());
        return new PlacedStructurePart(relativePos, config.id, config.part);
    }

    private static void runWithCoords(List<List<String>> layout, Consumer<AnnotatedPos> consumer) {
        int y = 0;
        for (List<String> layer : layout) {
            int x = 0;
            for (String row : layer) {
                int z = 0;
                ArrayList<Character> chars = new ArrayList<Character>(row.chars().mapToObj(e -> Character.valueOf((char)e)).toList());
                Collections.reverse(chars);
                for (char c : chars) {
                    consumer.accept(new AnnotatedPos(new BlockPos(x, y, z), Character.valueOf(c)));
                    ++z;
                }
                ++x;
            }
            ++y;
        }
    }

    private static List<TypedTransformedParts> applyTransforms(List<PlacedStructurePart> flattened) {
        ArrayList<TypedTransformedParts> result = new ArrayList<TypedTransformedParts>();
        result.add(new TypedTransformedParts(flattened, null));
        for (Map.Entry entry : MMRegistries.STRUCTURE_TRANSFORMS.get().getEntries()) {
            List<PlacedStructurePart> transformed = ((MMStructureTransform)entry.getValue()).transform(flattened);
            result.add(new TypedTransformedParts(transformed, MMRegistries.STRUCTURE_TRANSFORMS.get().getKey((Object)((MMStructureTransform)entry.getValue()))));
        }
        return result;
    }

    public record IdentifiedStructurePart(ResourceLocation id, IConfiguredStructurePart part) {
    }

    private record AnnotatedPos(BlockPos pos, Character character) {
    }

    public record PlacedStructurePart(BlockPos pos, ResourceLocation partId, IConfiguredStructurePart part) {
    }

    public record TypedTransformedParts(List<PlacedStructurePart> parts, ResourceLocation transformId) {
    }
}

