/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.recipe.IConfiguredRecipeEntry;
import io.ticticboom.mods.mm.recipe.MMRecipeEntry;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.util.ParseHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record RecipeModel(ResourceLocation id, Component name, ResourceLocation structureId, int duration, List<RecipeEntry> inputs, List<RecipeEntry> outputs) {
    public static RecipeModel parse(ResourceLocation id, JsonObject json) {
        ResourceLocation structureId = ResourceLocation.m_135820_((String)json.get("structureId").getAsString());
        Component name = ParseHelper.parseName(json.getAsJsonObject("name"), "");
        int duration = json.get("duration").getAsInt();
        List<RecipeEntry> inputs = RecipeModel.parseEntries(json.getAsJsonArray("inputs"));
        List<RecipeEntry> outputs = RecipeModel.parseEntries(json.getAsJsonArray("outputs"));
        return new RecipeModel(id, name, structureId, duration, inputs, outputs);
    }

    public static List<RecipeEntry> parseEntries(JsonArray arr) {
        ArrayList<RecipeEntry> result = new ArrayList<RecipeEntry>();
        for (JsonElement elem : arr) {
            JsonObject json = elem.getAsJsonObject();
            ResourceLocation type = ResourceLocation.m_135820_((String)json.get("type").getAsString());
            MMRecipeEntry entry = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(type);
            result.add(new RecipeEntry(type, entry.parse(json)));
        }
        return result;
    }

    public record RecipeEntry(ResourceLocation type, IConfiguredRecipeEntry config) {
    }
}

