/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup.model;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.ports.base.IConfiguredPort;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.util.ParseHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public record PortModel(ResourceLocation id, ResourceLocation port, IConfiguredPort configuredPort, boolean input, ResourceLocation blockId, Component name) {
    public static PortModel parse(JsonObject json) {
        ResourceLocation id = new ResourceLocation("mm", json.get("id").getAsString());
        ResourceLocation port = ResourceLocation.m_135820_((String)json.get("port").getAsString());
        MMPortTypeEntry value = MMRegistries.PORTS.get(port);
        if (value == null) {
            Ref.LOG.error("Port Type: {}, doesnt exist", (Object)port);
        }
        IConfiguredPort configuredPort = value.parse(json.get("config").getAsJsonObject());
        boolean input = json.get("input").getAsBoolean();
        ResourceLocation blockId = ResourceLocation.m_135820_((String)(id + "_port"));
        Component name = ParseHelper.parseName(json.get("name").getAsJsonObject(), "Port");
        return new PortModel(id, port, configuredPort, input, blockId, name);
    }
}

