/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.setup;

import com.google.gson.Gson;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.kube.MMEvents;
import io.ticticboom.mods.mm.compat.kube.porttypes.PortTypeEventHandler;
import io.ticticboom.mods.mm.compat.kube.recipeentry.RecipeEntryEventHandler;
import io.ticticboom.mods.mm.item.BlueprintItem;
import io.ticticboom.mods.mm.item.StructureSelectorWand;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.ports.createrotation.RotationPortTypeEntry;
import io.ticticboom.mods.mm.ports.energy.EnergyPortTypeEntry;
import io.ticticboom.mods.mm.ports.fluid.FluidPortTypeEntry;
import io.ticticboom.mods.mm.ports.item.ItemPortTypeEntry;
import io.ticticboom.mods.mm.ports.mekanism.gas.MekGasPortTypeEntry;
import io.ticticboom.mods.mm.ports.mekanism.heat.MekHeatPortTypeEntry;
import io.ticticboom.mods.mm.ports.mekanism.infuse.MekInfusePortTypeEntry;
import io.ticticboom.mods.mm.ports.mekanism.laser.MekLaserPortTypeEntry;
import io.ticticboom.mods.mm.ports.mekanism.pigment.MekPigmentPortTypeEntry;
import io.ticticboom.mods.mm.ports.mekanism.slurry.MekSlurryPortTypeEntry;
import io.ticticboom.mods.mm.recipe.MMRecipeEntry;
import io.ticticboom.mods.mm.recipe.connected.input.InputConnectedRecipeEntry;
import io.ticticboom.mods.mm.recipe.connected.output.OutputConnectedRecipeEntry;
import io.ticticboom.mods.mm.recipe.designated.DesignatedRecipeEntry;
import io.ticticboom.mods.mm.recipe.dimension.DimensionRecipeEntry;
import io.ticticboom.mods.mm.recipe.gates.and.AndGateRecipeEntry;
import io.ticticboom.mods.mm.recipe.pertick.PerTickRecipeEntry;
import io.ticticboom.mods.mm.recipe.preset.PresetRecipeEntry;
import io.ticticboom.mods.mm.recipe.simple.SimpleRecipeEntry;
import io.ticticboom.mods.mm.setup.ControllerManager;
import io.ticticboom.mods.mm.setup.PortManager;
import io.ticticboom.mods.mm.structure.MMStructurePart;
import io.ticticboom.mods.mm.structure.block.BlockStructurePart;
import io.ticticboom.mods.mm.structure.blockstate.BlockstateStructurePart;
import io.ticticboom.mods.mm.structure.gates.and.AndGateStructurePart;
import io.ticticboom.mods.mm.structure.gates.or.OrGateStructurePart;
import io.ticticboom.mods.mm.structure.port.PortStructurePart;
import io.ticticboom.mods.mm.structure.portblock.PortBlockStructurePart;
import io.ticticboom.mods.mm.structure.tag.BlockTagStructurePart;
import io.ticticboom.mods.mm.structure.transformers.MMStructureTransform;
import io.ticticboom.mods.mm.structure.transformers.RotationStructureTransform;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MMRegistries {
    public static final Gson GSON = new Gson();
    public static DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"mm");
    public static DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mm");
    public static DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"mm");
    public static DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"mm");
    public static Map<ResourceLocation, MMPortTypeEntry> PORTS = new HashMap<ResourceLocation, MMPortTypeEntry>();
    public static Supplier<IForgeRegistry<MMRecipeEntry>> RECIPE_ENTRIES;
    public static Supplier<IForgeRegistry<MMStructurePart>> STRUCTURE_PARTS;
    public static Supplier<IForgeRegistry<MMStructureTransform>> STRUCTURE_TRANSFORMS;
    public static final RegistryObject<Item> BLUEPRINT;
    public static final RegistryObject<Item> STRUCTURE_GEN_WAND;

    @SubscribeEvent
    public static void on(NewRegistryEvent event) {
        STRUCTURE_PARTS = event.create(new RegistryBuilder().setName(Ref.STRUCTURE_PART_REGISTRY));
        RECIPE_ENTRIES = event.create(new RegistryBuilder().setName(Ref.RECIPE_ENTRIES_REGISTRY));
        STRUCTURE_TRANSFORMS = event.create(new RegistryBuilder().setName(Ref.STRUCTURE_TRANSFORMS_REGISTRY));
    }

    @SubscribeEvent
    public static void registerStructureParts(RegisterEvent event) {
        event.register(STRUCTURE_PARTS.get().getRegistryKey(), Ref.StructureParts.BLOCK, BlockStructurePart::new);
        event.register(STRUCTURE_PARTS.get().getRegistryKey(), Ref.StructureParts.TAG, BlockTagStructurePart::new);
        event.register(STRUCTURE_PARTS.get().getRegistryKey(), Ref.StructureParts.PORT, PortStructurePart::new);
        event.register(STRUCTURE_PARTS.get().getRegistryKey(), Ref.StructureParts.PORT_BLOCK, PortBlockStructurePart::new);
        event.register(STRUCTURE_PARTS.get().getRegistryKey(), Ref.StructureParts.BLOCKSTATE, BlockstateStructurePart::new);
        event.register(STRUCTURE_PARTS.get().getRegistryKey(), Ref.StructureParts.AND, AndGateStructurePart::new);
        event.register(STRUCTURE_PARTS.get().getRegistryKey(), Ref.StructureParts.OR, OrGateStructurePart::new);
    }

    @SubscribeEvent
    public static void registerRecipeEntries(RegisterEvent event) {
        event.register(RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.SIMPLE, SimpleRecipeEntry::new);
        event.register(RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.PER_TICK, PerTickRecipeEntry::new);
        event.register(RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.AND_GATE, AndGateRecipeEntry::new);
        event.register(RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.PRESET, PresetRecipeEntry::new);
        event.register(RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.DESIGNATED, DesignatedRecipeEntry::new);
        event.register(RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.CONNECTED_OUTPUT, OutputConnectedRecipeEntry::new);
        event.register(RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.CONNECTED_INPUT, InputConnectedRecipeEntry::new);
        event.register(RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.DIMENSION, DimensionRecipeEntry::new);
        MMEvents.RECIPE_ENTRY.post((EventJS)new RecipeEntryEventHandler());
    }

    @SubscribeEvent
    public static void registerStructureTransforms(RegisterEvent event) {
        event.register(STRUCTURE_TRANSFORMS.get().getRegistryKey(), Ref.StructureTransforms.ROT_90, () -> new RotationStructureTransform(Rotation.CLOCKWISE_90));
        event.register(STRUCTURE_TRANSFORMS.get().getRegistryKey(), Ref.StructureTransforms.ROT_180, () -> new RotationStructureTransform(Rotation.CLOCKWISE_180));
        event.register(STRUCTURE_TRANSFORMS.get().getRegistryKey(), Ref.StructureTransforms.ROT_270, () -> new RotationStructureTransform(Rotation.COUNTERCLOCKWISE_90));
    }

    public static void registerPorts() {
        PORTS.put(Ref.Ports.ITEM, new ItemPortTypeEntry());
        PORTS.put(Ref.Ports.FLUID, new FluidPortTypeEntry());
        PORTS.put(Ref.Ports.ENERGY, new EnergyPortTypeEntry());
        if (ModList.get().isLoaded("create")) {
            PORTS.put(Ref.Ports.CREATE_ROT, new RotationPortTypeEntry());
        }
        if (ModList.get().isLoaded("mekanism")) {
            PORTS.put(Ref.Ports.MEK_GAS, new MekGasPortTypeEntry());
            PORTS.put(Ref.Ports.MEK_INFUSE, new MekInfusePortTypeEntry());
            PORTS.put(Ref.Ports.MEK_PIGMENT, new MekPigmentPortTypeEntry());
            PORTS.put(Ref.Ports.MEK_SLURRY, new MekSlurryPortTypeEntry());
            PORTS.put(Ref.Ports.MEK_HEAT, new MekHeatPortTypeEntry());
            PORTS.put(Ref.Ports.MEK_LASER, new MekLaserPortTypeEntry());
        }
    }

    @SubscribeEvent
    public static void on(FMLConstructModEvent event) {
        event.enqueueWork(() -> {
            if (ModList.get().isLoaded("kubejs")) {
                MMEvents.PORT_TYPE.post((ScriptTypeHolder)ScriptType.STARTUP, (EventJS)new PortTypeEventHandler());
            }
            ControllerManager.load();
            PortManager.load();
        });
    }

    public static void register() {
        MMRegistries.registerPorts();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_ENTITIES.register(bus);
        MENU_TYPES.register(bus);
    }

    static {
        BLUEPRINT = ITEMS.register("blueprint", BlueprintItem::new);
        STRUCTURE_GEN_WAND = ITEMS.register("structure_wand", StructureSelectorWand::new);
    }
}

