/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.recipe.simple;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.ports.base.ConfiguredIngredient;
import io.ticticboom.mods.mm.ports.base.IOPortStorage;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.recipe.IConfiguredRecipeEntry;
import io.ticticboom.mods.mm.recipe.MMRecipeEntry;
import io.ticticboom.mods.mm.recipe.RecipeContext;
import io.ticticboom.mods.mm.recipe.simple.SimpleConfiguredRecipeEntry;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.util.RecipeHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;

public class SimpleRecipeEntry
extends MMRecipeEntry {
    private final Random rand = new Random();

    @Override
    public IConfiguredRecipeEntry parse(JsonObject json) {
        ConfiguredIngredient ingredient = RecipeHelper.parseIngredient(json.get("ingredient").getAsJsonObject());
        Optional<Float> chance = Optional.empty();
        if (json.has("chance")) {
            chance = Optional.of(Float.valueOf(json.get("chance").getAsFloat()));
        }
        return new SimpleConfiguredRecipeEntry(ingredient, chance);
    }

    @Override
    public boolean processInputs(IConfiguredRecipeEntry config, RecipeContext original, RecipeContext ctx) {
        SimpleConfiguredRecipeEntry conf = (SimpleConfiguredRecipeEntry)config;
        if (!this.roll(conf.chance())) {
            return true;
        }
        ResourceLocation type = conf.ingredient().type();
        MMPortTypeEntry port = MMRegistries.PORTS.get(type);
        return port.processInputs(conf.ingredient().config(), ctx.inputPorts().stream().map(IOPortStorage::port).toList());
    }

    @Override
    public boolean processOutputs(IConfiguredRecipeEntry config, RecipeContext original, RecipeContext ctx) {
        SimpleConfiguredRecipeEntry conf = (SimpleConfiguredRecipeEntry)config;
        if (!this.roll(conf.chance())) {
            return true;
        }
        ResourceLocation type = conf.ingredient().type();
        MMPortTypeEntry port = MMRegistries.PORTS.get(type);
        return port.processOutputs(conf.ingredient().config(), ctx.outputPorts().stream().map(IOPortStorage::port).toList());
    }

    protected boolean roll(Optional<Float> chance) {
        if (chance.isPresent()) {
            float random = this.rand.nextFloat();
            return random <= chance.get().floatValue();
        }
        return true;
    }
}

