/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.recipe.designated;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.ports.base.IOPortStorage;
import io.ticticboom.mods.mm.recipe.ConfiguredRecipeEntry;
import io.ticticboom.mods.mm.recipe.IConfiguredRecipeEntry;
import io.ticticboom.mods.mm.recipe.MMRecipeEntry;
import io.ticticboom.mods.mm.recipe.RecipeContext;
import io.ticticboom.mods.mm.recipe.designated.DesignatedConfiguredRecipeEntry;
import io.ticticboom.mods.mm.setup.MMRegistries;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class DesignatedRecipeEntry
extends MMRecipeEntry {
    @Override
    public IConfiguredRecipeEntry parse(JsonObject json) {
        String portId = json.get("portId").getAsString();
        JsonObject obj = json.getAsJsonObject("entry");
        ResourceLocation type = ResourceLocation.m_135820_((String)obj.get("type").getAsString());
        MMRecipeEntry entry = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(type);
        return new DesignatedConfiguredRecipeEntry(new ConfiguredRecipeEntry(type, entry.parse(obj)), portId);
    }

    @Override
    public boolean processInputs(IConfiguredRecipeEntry config, RecipeContext original, RecipeContext ctx) {
        DesignatedConfiguredRecipeEntry conf = (DesignatedConfiguredRecipeEntry)config;
        for (IOPortStorage inputPort : ctx.inputPorts()) {
            if (!inputPort.name().equals(conf.portId())) continue;
            MMRecipeEntry value = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(conf.entry().type());
            RecipeContext newOriginal = new RecipeContext(original.structure(), original.recipe(), original.appliedTransformId(), (List<IOPortStorage>)ImmutableList.of((Object)inputPort), original.outputPorts(), original.level(), original.controllerPos(), original.contexts());
            RecipeContext newCtx = new RecipeContext(ctx.structure(), ctx.recipe(), ctx.appliedTransformId(), (List<IOPortStorage>)ImmutableList.of((Object)inputPort), ctx.outputPorts(), ctx.level(), ctx.controllerPos(), ctx.contexts());
            return value.processInputs(conf.entry().entry(), newOriginal, newCtx);
        }
        return false;
    }

    @Override
    public boolean processOutputs(IConfiguredRecipeEntry config, RecipeContext original, RecipeContext ctx) {
        DesignatedConfiguredRecipeEntry conf = (DesignatedConfiguredRecipeEntry)config;
        for (IOPortStorage inputPort : ctx.outputPorts()) {
            if (!inputPort.name().equals(conf.portId())) continue;
            MMRecipeEntry value = (MMRecipeEntry)MMRegistries.RECIPE_ENTRIES.get().getValue(conf.entry().type());
            RecipeContext newOriginal = new RecipeContext(original.structure(), original.recipe(), original.appliedTransformId(), (List<IOPortStorage>)ImmutableList.of((Object)inputPort), original.outputPorts(), original.level(), original.controllerPos(), original.contexts());
            RecipeContext newCtx = new RecipeContext(ctx.structure(), ctx.recipe(), ctx.appliedTransformId(), (List<IOPortStorage>)ImmutableList.of((Object)inputPort), ctx.outputPorts(), ctx.level(), ctx.controllerPos(), ctx.contexts());
            return value.processOutputs(conf.entry().entry(), newOriginal, newCtx);
        }
        return false;
    }
}

