/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.mekanism.heat;

import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.mekanism.heat.MekHeatConfiguredPort;
import io.ticticboom.mods.mm.ports.mekanism.heat.MekHeatHandler;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MekHeatPortStorage
extends PortStorage {
    public final MekHeatConfiguredPort config;
    public final MekHeatHandler handler;
    public final LazyOptional<IHeatHandler> handlerLO;

    public MekHeatPortStorage(MekHeatConfiguredPort config) {
        this.config = config;
        this.handler = new MekHeatHandler(config);
        this.handlerLO = LazyOptional.of(() -> this.handler);
    }

    @Override
    public void read(CompoundTag tag) {
        this.handler.capacitor.setHeatCapacityFromPacket(tag.m_128459_("Heat"));
    }

    @Override
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("Heat", this.handler.capacitor.getHeat());
        return tag;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == Capabilities.HEAT_HANDLER) {
            return this.handlerLO.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void onDestroy(Level level, BlockPos pos) {
    }

    @Override
    public PortStorage deepClone() {
        MekHeatPortStorage res = new MekHeatPortStorage(this.config);
        res.handler.capacitor.setHeat(this.handler.capacitor.getHeat());
        return res;
    }

    @Override
    public void tick() {
        this.handler.capacitor.update();
    }
}

