/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.item;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.ports.base.IConfiguredIngredient;
import io.ticticboom.mods.mm.ports.base.IConfiguredPort;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.item.ItemConfiguredIngredient;
import io.ticticboom.mods.mm.ports.item.ItemConfiguredPort;
import io.ticticboom.mods.mm.ports.item.ItemPortStorage;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemPortTypeEntry
extends MMPortTypeEntry {
    @Override
    public Class<? extends PortStorage> storageClass() {
        return ItemPortStorage.class;
    }

    @Override
    public IConfiguredPort parse(JsonObject element) {
        int rows = element.get("slotRows").getAsInt();
        int cols = element.get("slotCols").getAsInt();
        return new ItemConfiguredPort(rows, cols);
    }

    @Override
    public IConfiguredIngredient parseIngredient(JsonObject json) {
        ResourceLocation item = ResourceLocation.m_135820_((String)json.get("item").getAsString());
        int count = json.get("count").getAsInt();
        return new ItemConfiguredIngredient(item, count);
    }

    @Override
    public ResourceLocation overlay(boolean input) {
        return input ? Ref.res("block/base_ports/item_input_cutout") : Ref.res("block/base_ports/item_output_cutout");
    }

    @Override
    public PortStorage createStorage(IConfiguredPort config) {
        return new ItemPortStorage((ItemConfiguredPort)config);
    }

    @Override
    public boolean processInputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        ItemConfiguredIngredient conf = (ItemConfiguredIngredient)ingredient;
        int itemCounter = 0;
        for (PortStorage portStorage : storage) {
            if (!(portStorage instanceof ItemPortStorage)) continue;
            ItemPortStorage itemPortStorage = (ItemPortStorage)portStorage;
            for (int i = 0; i < itemPortStorage.items.getSlots(); ++i) {
                ItemStack slot = itemPortStorage.items.getStackInSlot(i);
                int requiredAmount = conf.count() - itemCounter;
                if (!ForgeRegistries.ITEMS.getKey((Object)slot.m_41720_()).equals((Object)conf.item())) continue;
                if (slot.m_41613_() >= requiredAmount) {
                    int remains = slot.m_41613_() - requiredAmount;
                    itemCounter += requiredAmount;
                    slot.m_41764_(remains);
                    continue;
                }
                itemCounter += slot.m_41613_();
                slot.m_41764_(0);
            }
            if (itemCounter < conf.count()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean processOutputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        ItemConfiguredIngredient conf = (ItemConfiguredIngredient)ingredient;
        int itemCounter = 0;
        Item item = (Item)ForgeRegistries.ITEMS.getValue(conf.item());
        int maxStack = item.m_41459_();
        for (PortStorage portStorage : storage) {
            if (!(portStorage instanceof ItemPortStorage)) continue;
            ItemPortStorage itemPortStorage = (ItemPortStorage)portStorage;
            for (int i = 0; i < itemPortStorage.items.getSlots(); ++i) {
                ItemStack slot = itemPortStorage.items.getStackInSlot(i);
                int requiredAmount = conf.count() - itemCounter;
                if (ForgeRegistries.ITEMS.getKey((Object)slot.m_41720_()).equals((Object)conf.item())) {
                    int availableSpace = maxStack - slot.m_41613_();
                    int remains = Math.min(availableSpace, requiredAmount);
                    itemCounter += remains;
                    slot.m_41764_(slot.m_41613_() + remains);
                    continue;
                }
                if (!slot.m_41619_()) continue;
                itemCounter += maxStack;
                int remains = Math.min(maxStack, requiredAmount);
                itemPortStorage.items.setStackInSlot(i, new ItemStack((ItemLike)item, remains));
            }
            if (itemCounter < conf.count()) continue;
            return true;
        }
        return false;
    }
}

