/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.item;

import io.ticticboom.mods.mm.capability.MMCapabilities;
import io.ticticboom.mods.mm.client.container.PortContainer;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.item.ItemConfiguredPort;
import io.ticticboom.mods.mm.ports.item.ItemContainer;
import io.ticticboom.mods.mm.ports.item.ItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class ItemPortStorage
extends PortStorage {
    public ItemConfiguredPort config;
    public final ItemHandler items;
    public final LazyOptional<ItemStackHandler> handlerLO;
    public final ItemContainer inv;

    public ItemPortStorage(ItemConfiguredPort config) {
        this.config = config;
        this.items = new ItemHandler(config.slotCols() * config.slotRows());
        this.handlerLO = LazyOptional.of(() -> this.items);
        this.inv = new ItemContainer(this.items);
    }

    @Override
    public void read(CompoundTag tag) {
        ContainerHelper.m_18980_((CompoundTag)tag, this.items.getStacks());
    }

    @Override
    public CompoundTag write() {
        CompoundTag result = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)result, this.items.getStacks());
        return result;
    }

    public Vec2 getSlotStart() {
        int slot = 18;
        float colP = (float)this.config.slotCols() / 9.0f;
        float rowP = (float)this.config.slotRows() / 6.0f;
        int defaultWidth = 162;
        int defaultHeight = 108;
        float actualWidth = (float)defaultWidth * colP;
        float actualHeight = (float)defaultHeight * rowP;
        float actualX = (float)(defaultWidth / 2) - actualWidth / 2.0f;
        float actualY = (float)(defaultHeight / 2) - actualHeight / 2.0f;
        return new Vec2(actualX + 8.0f, actualY + 8.0f);
    }

    @Override
    public void setupContainer(PortContainer container, Inventory pinv, BlockEntity be) {
        super.setupContainer(container, pinv, be);
        Vec2 start = this.getSlotStart();
        for (int x = 0; x < this.config.slotCols(); ++x) {
            for (int y = 0; y < this.config.slotRows(); ++y) {
                container.m_38897_(new Slot((Container)this.inv, x + y * this.config.slotCols(), (int)start.f_82470_ + x * 18, (int)start.f_82471_ + y * 18));
            }
        }
    }

    @Override
    public void onDestroy(Level level, BlockPos pos) {
        Containers.m_19002_((Level)level, (BlockPos)pos, (Container)this.inv);
    }

    @Override
    public PortStorage deepClone() {
        ItemPortStorage copy = new ItemPortStorage(this.config);
        for (int i = 0; i < copy.items.getSlots(); ++i) {
            ItemStack itemClone = this.items.getStackInSlot(i).m_41777_();
            copy.items.setStackInSlot(i, itemClone);
        }
        return copy;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == MMCapabilities.ITEMS) {
            return this.handlerLO.cast();
        }
        return LazyOptional.empty();
    }
}

