/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.energy;

import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.ports.base.IConfiguredIngredient;
import io.ticticboom.mods.mm.ports.base.IConfiguredPort;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.energy.EnergyConfiguredIngredient;
import io.ticticboom.mods.mm.ports.energy.EnergyConfiguredPort;
import io.ticticboom.mods.mm.ports.energy.EnergyPortStorage;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class EnergyPortTypeEntry
extends MMPortTypeEntry {
    @Override
    public Class<? extends PortStorage> storageClass() {
        return EnergyPortStorage.class;
    }

    @Override
    public IConfiguredPort parse(JsonObject element) {
        int capacity = element.get("capacity").getAsInt();
        return new EnergyConfiguredPort(capacity);
    }

    @Override
    public IConfiguredIngredient parseIngredient(JsonObject json) {
        int amount = json.get("amount").getAsInt();
        return new EnergyConfiguredIngredient(amount);
    }

    @Override
    public ResourceLocation overlay(boolean input) {
        return input ? Ref.res("block/base_ports/energy_input_cutout") : Ref.res("block/base_ports/energy_output_cutout");
    }

    @Override
    public PortStorage createStorage(IConfiguredPort config) {
        return new EnergyPortStorage((EnergyConfiguredPort)config);
    }

    @Override
    public boolean processInputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        EnergyConfiguredIngredient conf = (EnergyConfiguredIngredient)ingredient;
        int itemCounter = 0;
        for (PortStorage portStorage : storage) {
            if (!(portStorage instanceof EnergyPortStorage)) continue;
            EnergyPortStorage eps = (EnergyPortStorage)portStorage;
            if ((itemCounter += eps.handler.extractEnergy(conf.amount(), false)) < conf.amount()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean processOutputs(IConfiguredIngredient ingredient, List<PortStorage> storage) {
        EnergyConfiguredIngredient conf = (EnergyConfiguredIngredient)ingredient;
        int itemCounter = 0;
        for (PortStorage portStorage : storage) {
            if (!(portStorage instanceof EnergyPortStorage)) continue;
            EnergyPortStorage eps = (EnergyPortStorage)portStorage;
            if ((itemCounter += eps.handler.receiveEnergy(conf.amount(), false)) < conf.amount()) continue;
            return true;
        }
        return false;
    }
}

