/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.ports.energy;

import io.ticticboom.mods.mm.capability.MMCapabilities;
import io.ticticboom.mods.mm.ports.base.PortStorage;
import io.ticticboom.mods.mm.ports.energy.EnergyConfiguredPort;
import io.ticticboom.mods.mm.ports.energy.EnergyHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyPortStorage
extends PortStorage {
    public EnergyConfiguredPort config;
    public EnergyHandler handler;
    public final LazyOptional<EnergyHandler> handlerLO;

    public EnergyPortStorage(EnergyConfiguredPort config) {
        this.config = config;
        this.handler = new EnergyHandler(config.capacity());
        this.handlerLO = LazyOptional.of(() -> this.handler);
    }

    @Override
    public void read(CompoundTag tag) {
        int stored = tag.m_128451_("Amount");
        this.handler.setStored(stored);
    }

    @Override
    public CompoundTag write() {
        CompoundTag result = new CompoundTag();
        result.m_128405_("Amount", this.handler.getEnergyStored());
        return result;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap) {
        if (cap == MMCapabilities.ENERGY) {
            return this.handlerLO.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void onDestroy(Level level, BlockPos pos) {
    }

    @Override
    public PortStorage deepClone() {
        EnergyPortStorage result = new EnergyPortStorage(this.config);
        result.handler = new EnergyHandler(this.config.capacity());
        result.handler.setStored(this.handler.getEnergyStored());
        return result;
    }
}

