/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.datagen.gen;

import io.ticticboom.mods.mm.block.ControllerBlock;
import io.ticticboom.mods.mm.ports.base.IPortBlock;
import io.ticticboom.mods.mm.setup.MMRegistries;
import java.util.List;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;

public class MMLangProvider
extends LanguageProvider {
    public MMLangProvider(DataGenerator gen) {
        super(gen, "mm", "en_us");
    }

    protected void addTranslations() {
        List<RegistryObject> controllers = MMRegistries.BLOCKS.getEntries().stream().filter(x -> x.get() instanceof ControllerBlock).toList();
        List<RegistryObject> ports = MMRegistries.BLOCKS.getEntries().stream().filter(x -> x.get() instanceof IPortBlock).toList();
        for (RegistryObject controller : controllers) {
            ControllerBlock controllerBlock = (ControllerBlock)((Object)controller.get());
            this.add((Block)controller.get(), controllerBlock.model().name().getString());
            this.add("container.masterfulmachinery." + controllerBlock.model().blockId() + "_controller.name", controllerBlock.model().name().getString());
        }
        for (RegistryObject port : ports) {
            IPortBlock portBlock = (IPortBlock)port.get();
            this.add((Block)port.get(), portBlock.model().name().getString() + " " + (portBlock.model().input() ? "Input" : "Output") + " Port");
        }
        this.add((Item)MMRegistries.BLUEPRINT.get(), "Blueprint");
        this.add((Item)MMRegistries.STRUCTURE_GEN_WAND.get(), "Structure Wand");
    }
}

