/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.datagen.gen;

import io.ticticboom.mods.mm.block.ControllerBlock;
import io.ticticboom.mods.mm.ports.base.IPortBlock;
import io.ticticboom.mods.mm.ports.base.MMPortTypeEntry;
import io.ticticboom.mods.mm.setup.MMRegistries;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.CompositeModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class MMBlockStateProvider
extends BlockStateProvider {
    public static final ResourceLocation BASE_TEXTURE = new ResourceLocation("mm", "block/base_block");
    private static final ResourceLocation CONTROLLER_TEXTURE = new ResourceLocation("mm", "block/controller_cutout");

    public MMBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "mm", exFileHelper);
    }

    protected void registerStatesAndModels() {
        List<RegistryObject> controllers = MMRegistries.BLOCKS.getEntries().stream().filter(x -> x.get() instanceof ControllerBlock).toList();
        List<RegistryObject> ports = MMRegistries.BLOCKS.getEntries().stream().filter(x -> x.get() instanceof IPortBlock).toList();
        for (RegistryObject controller : controllers) {
            if (!controller.isPresent()) {
                return;
            }
            this.dynamicBlockNorthOverlay(controller.getId(), BASE_TEXTURE, CONTROLLER_TEXTURE);
            VariantBlockStateBuilder variantBuilder = this.getVariantBuilder((Block)controller.get());
            variantBuilder.partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("mm", "block/" + controller.getId().m_135815_()))).rotationY(0).addModel();
            variantBuilder.partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("mm", "block/" + controller.getId().m_135815_()))).rotationY(180).addModel();
            variantBuilder.partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("mm", "block/" + controller.getId().m_135815_()))).rotationY(90).addModel();
            variantBuilder.partialState().with((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("mm", "block/" + controller.getId().m_135815_()))).rotationY(270).addModel();
        }
        for (RegistryObject port : ports) {
            MMPortTypeEntry portType = MMRegistries.PORTS.get(((IPortBlock)port.get()).model().port());
            portType.generateBlockStates(this, (Block)port.get());
        }
    }

    private void dynamicBlockNorthOverlay(ResourceLocation loc, ResourceLocation baseTexture, ResourceLocation overlayTexture) {
        ((CompositeModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(loc.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/block")))).texture("particle", overlayTexture)).customLoader(CompositeModelBuilder::begin)).child("solid", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/block")))).texture("base", baseTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#base").end())).child("translucent", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/block")))).texture("overlay", overlayTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).face(Direction.NORTH).texture("#overlay").end().end())).end();
    }

    public void dynamicBlock(ResourceLocation loc, ResourceLocation baseTexture, ResourceLocation overlayTexture) {
        ((CompositeModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(loc.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/block")))).texture("particle", overlayTexture)).customLoader(CompositeModelBuilder::begin)).child("solid", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/block")))).texture("base", baseTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).cube("#base").end())).child("trnaslucent", (ModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().nested()).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("block/block")))).texture("overlay", overlayTexture)).element().from(0.0f, 0.0f, 0.0f).to(16.0f, 16.0f, 16.0f).allFaces((dir, uv) -> uv.texture("#overlay")).end())).end();
    }
}

