/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.ticticboom.mods.mm.ModRoot;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.util.GsonHelper;

public class GeneratedPack
implements PackResources {
    private final Path path;

    public GeneratedPack(Path path) {
        ModRoot.generate();
        this.path = path;
    }

    private static String getFullPath(PackType type, ResourceLocation location) {
        return String.format("%s/%s/%s", type.m_10305_(), location.m_135827_(), location.m_135815_());
    }

    public InputStream m_5542_(String fileName) throws IOException {
        Path resolved = this.path.resolve(fileName);
        return Files.newInputStream(resolved, new OpenOption[0]);
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        Path resolved = this.path.resolve(GeneratedPack.getFullPath(type, location));
        if (!Files.exists(resolved, new LinkOption[0])) {
            throw new IOException("Resource does not exist");
        }
        return Files.newInputStream(resolved, new OpenOption[0]);
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String namespaceIn, String pathIn, Predicate<ResourceLocation> filterIn) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        this.getChildResourceLocations(result, 0, filterIn, this.path.resolve(type.m_10305_() + "/" + namespaceIn + "/" + pathIn), namespaceIn, pathIn);
        return result;
    }

    private void getChildResourceLocations(List<ResourceLocation> result, int depth, Predicate<ResourceLocation> filter, Path current, String currentRLNS, String currentRLPath) {
        try {
            if (!Files.exists(current, new LinkOption[0]) || !Files.isDirectory(current, new LinkOption[0])) {
                return;
            }
            Stream<Path> list = Files.list(current);
            for (Path child : list.collect(Collectors.toList())) {
                if (!Files.isDirectory(child, new LinkOption[0])) {
                    result.add(new ResourceLocation(currentRLNS, currentRLPath + "/" + child.getFileName()));
                    continue;
                }
                this.getChildResourceLocations(result, depth + 1, filter, child, currentRLNS, currentRLPath + "/" + child.getFileName());
            }
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        Path finalPath = this.path.resolve(type.m_10305_() + "/" + location.m_135827_() + "/" + location.m_135815_());
        return Files.exists(finalPath, new LinkOption[0]);
    }

    public Set<String> m_5698_(PackType type) {
        HashSet<String> result = new HashSet<String>();
        try {
            Stream<Path> list = Files.list(this.path.resolve(type.m_10305_()));
            for (Path resultingPath : list.toList()) {
                result.add(resultingPath.getFileName().toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        JsonObject jsonobject = new JsonObject();
        JsonObject packObject = new JsonObject();
        packObject.addProperty("pack_format", (Number)9);
        packObject.addProperty("description", "mm");
        jsonobject.add("pack", (JsonElement)packObject);
        if (!jsonobject.has(deserializer.m_7991_())) {
            return null;
        }
        try {
            return (T)deserializer.m_6322_(GsonHelper.m_13930_((JsonObject)jsonobject, (String)deserializer.m_7991_()));
        }
        catch (JsonParseException jsonparseexception) {
            return null;
        }
    }

    public String m_8017_() {
        return "MM Generated Pack";
    }

    public void close() {
    }
}

