/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.kube.port;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.setup.PortManager;
import io.ticticboom.mods.mm.setup.model.PortModel;

public class PortBuilderJS {
    private String id;
    private String port;
    private boolean input;
    private String name;
    private JsonObject config;

    public void build() {
        JsonObject nameJson = new JsonObject();
        nameJson.addProperty("text", this.name);
        JsonObject port = new JsonObject();
        port.addProperty("id", this.id);
        port.addProperty("port", this.port);
        port.addProperty("input", Boolean.valueOf(this.input));
        port.add("name", (JsonElement)nameJson);
        port.add("config", (JsonElement)this.config);
        PortManager.REGISTRY.put(Ref.res(this.id), PortModel.parse(port));
    }

    public PortBuilderJS id(String id) {
        this.id = id;
        return this;
    }

    public PortBuilderJS port(String port) {
        this.port = port;
        return this;
    }

    public PortBuilderJS input(boolean input) {
        this.input = input;
        return this;
    }

    public PortBuilderJS name(String name) {
        this.name = name;
        return this;
    }

    public PortBuilderJS config(JsonObject config) {
        this.config = config;
        return this;
    }
}

