/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.MMCompatRegistries;
import io.ticticboom.mods.mm.compat.jei.SlotGrid;
import io.ticticboom.mods.mm.compat.jei.base.JeiRecipeEntry;
import io.ticticboom.mods.mm.setup.model.RecipeModel;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public class MMRecipeCategory
implements IRecipeCategory<RecipeModel> {
    public static final RecipeType<RecipeModel> RECIPE_TYPE = RecipeType.create((String)"mm", (String)"recipes", RecipeModel.class);
    private final IJeiHelpers helpers;

    public MMRecipeCategory(IJeiHelpers helpers) {
        this.helpers = helpers;
    }

    public RecipeType<RecipeModel> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237113_((String)"MM Recipe");
    }

    public IDrawable getBackground() {
        return this.helpers.getGuiHelper().createBlankDrawable(162, 100);
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeModel recipe, IFocusGroup focuses) {
        SlotGrid inputs = new SlotGrid(20, 20, 3, 5);
        for (RecipeModel.RecipeEntry input : recipe.inputs()) {
            JeiRecipeEntry entry = (JeiRecipeEntry)MMCompatRegistries.JEI_RECIPE_ENTRIES.get().getValue(input.type());
            if (entry == null) continue;
            entry.setRecipe(input.config(), builder, recipe, focuses, this.helpers, true, 0, 0, inputs);
        }
        SlotGrid outputs = new SlotGrid(20, 20, 3, 5);
        for (RecipeModel.RecipeEntry output : recipe.outputs()) {
            JeiRecipeEntry entry = (JeiRecipeEntry)MMCompatRegistries.JEI_RECIPE_ENTRIES.get().getValue(output.type());
            if (entry == null) continue;
            entry.setRecipe(output.config(), builder, recipe, focuses, this.helpers, false, 100, 0, outputs);
        }
    }

    public void draw(RecipeModel recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        SlotGrid inputs = new SlotGrid(20, 20, 3, 5);
        for (RecipeModel.RecipeEntry input : recipe.inputs()) {
            JeiRecipeEntry entry = (JeiRecipeEntry)MMCompatRegistries.JEI_RECIPE_ENTRIES.get().getValue(input.type());
            if (entry == null) continue;
            entry.renderJei(recipe, recipeSlotsView, stack, mouseX, mouseY, input.config(), this.helpers, true, 0, 0, inputs);
        }
        SlotGrid outputs = new SlotGrid(20, 20, 3, 5);
        for (RecipeModel.RecipeEntry output : recipe.outputs()) {
            JeiRecipeEntry entry = (JeiRecipeEntry)MMCompatRegistries.JEI_RECIPE_ENTRIES.get().getValue(output.type());
            if (entry == null) continue;
            entry.renderJei(recipe, recipeSlotsView, stack, mouseX, mouseY, output.config(), this.helpers, false, 100, 0, outputs);
        }
        this.helpers.getGuiHelper().createDrawable(Ref.SLOT_PARTS, 26, 0, 24, 17).draw(stack, 70, 5);
        Minecraft.m_91087_().f_91062_.m_92883_(stack, String.valueOf(recipe.duration()), 75.0f, 25.0f, 0x474747);
        Minecraft.m_91087_().f_91062_.m_92883_(stack, "Ticks", 70.0f, 35.0f, 0x474747);
    }
}

