/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat.jei;

import com.google.common.collect.ImmutableList;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.block.ControllerBlock;
import io.ticticboom.mods.mm.compat.MMCompatRegistries;
import io.ticticboom.mods.mm.compat.jei.MMRecipeCategory;
import io.ticticboom.mods.mm.compat.jei.base.JeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.recipe.DimensionJeiRecipeEntry;
import io.ticticboom.mods.mm.recipe.dimension.jei.DimIngredientHelper;
import io.ticticboom.mods.mm.recipe.dimension.jei.DimIngredientRenderer;
import io.ticticboom.mods.mm.setup.MMRegistries;
import io.ticticboom.mods.mm.setup.model.RecipeModel;
import io.ticticboom.mods.mm.setup.reload.RecipeManager;
import io.ticticboom.mods.mm.util.Deferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

@JeiPlugin
public class MMJeiPlugin
implements IModPlugin {
    private Deferred<IJeiHelpers> helpers = new Deferred();

    public ResourceLocation getPluginUid() {
        return Ref.res("jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<RecipeModel> recipes = new ArrayList<RecipeModel>();
        for (Map.Entry<ResourceLocation, RecipeModel> entry : RecipeManager.REGISTRY.entrySet()) {
            recipes.add(entry.getValue());
        }
        registration.addRecipes(MMRecipeCategory.RECIPE_TYPE, recipes);
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        for (Map.Entry entry : MMCompatRegistries.JEI_PORTS.get().getEntries()) {
            ((JeiPortTypeEntry)entry.getValue()).registerJeiIngredient(registration, this.helpers);
        }
        registration.register((IIngredientType)DimensionJeiRecipeEntry.ING_TYPE, (Collection)ImmutableList.of(), (IIngredientHelper)new DimIngredientHelper(), (IIngredientRenderer)new DimIngredientRenderer());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MMRecipeCategory(registration.getJeiHelpers())});
        this.helpers.set(registration.getJeiHelpers());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        List<RegistryObject> controllers = MMRegistries.BLOCKS.getEntries().stream().filter(x -> x.get() instanceof ControllerBlock).toList();
        for (RegistryObject controller : controllers) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)((Block)controller.get()).m_5456_()), new RecipeType[]{MMRecipeCategory.RECIPE_TYPE});
        }
    }
}

