/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm.compat;

import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.compat.jei.base.JeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.base.JeiRecipeEntry;
import io.ticticboom.mods.mm.compat.jei.port.EnergyJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.port.FluidJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.port.ItemJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.port.RotationJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.port.mek.MekGasJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.port.mek.MekHeatJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.port.mek.MekInfuseJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.port.mek.MekLaserJeiPortType;
import io.ticticboom.mods.mm.compat.jei.port.mek.MekPigmentJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.port.mek.MekSlurryJeiPortTypeEntry;
import io.ticticboom.mods.mm.compat.jei.recipe.AndGateJeiRecipeEntry;
import io.ticticboom.mods.mm.compat.jei.recipe.DesignatedJeiRecipeEntry;
import io.ticticboom.mods.mm.compat.jei.recipe.DimensionJeiRecipeEntry;
import io.ticticboom.mods.mm.compat.jei.recipe.PerTickJeiRecipeEntry;
import io.ticticboom.mods.mm.compat.jei.recipe.SimpleJeiRecipeEntry;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MMCompatRegistries {
    public static Supplier<IForgeRegistry<JeiRecipeEntry>> JEI_RECIPE_ENTRIES;
    public static Supplier<IForgeRegistry<JeiPortTypeEntry>> JEI_PORTS;

    public static void on(NewRegistryEvent event) {
        if (ModList.get().isLoaded("jei")) {
            JEI_RECIPE_ENTRIES = event.create(new RegistryBuilder().setName(Ref.CompatRegistries.JEI_RECIPE_ENTRIES));
            JEI_PORTS = event.create(new RegistryBuilder().setName(Ref.CompatRegistries.JEI_PORT_TYPES));
        }
    }

    public static void registerJeiRecipeEntries(RegisterEvent event) {
        event.register(JEI_RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.SIMPLE, SimpleJeiRecipeEntry::new);
        event.register(JEI_RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.PER_TICK, PerTickJeiRecipeEntry::new);
        event.register(JEI_RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.DESIGNATED, DesignatedJeiRecipeEntry::new);
        event.register(JEI_RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.AND_GATE, AndGateJeiRecipeEntry::new);
        event.register(JEI_RECIPE_ENTRIES.get().getRegistryKey(), Ref.RecipeEntries.DIMENSION, DimensionJeiRecipeEntry::new);
    }

    public static void registerJeiPorts(RegisterEvent event) {
        event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.ENERGY, EnergyJeiPortTypeEntry::new);
        event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.FLUID, FluidJeiPortTypeEntry::new);
        event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.ITEM, ItemJeiPortTypeEntry::new);
        if (ModList.get().isLoaded("create")) {
            event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.CREATE_ROT, RotationJeiPortTypeEntry::new);
        }
        if (ModList.get().isLoaded("mekanism")) {
            event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.MEK_GAS, MekGasJeiPortTypeEntry::new);
            event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.MEK_INFUSE, MekInfuseJeiPortTypeEntry::new);
            event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.MEK_PIGMENT, MekPigmentJeiPortTypeEntry::new);
            event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.MEK_SLURRY, MekSlurryJeiPortTypeEntry::new);
            event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.MEK_LASER, MekLaserJeiPortType::new);
            event.register(JEI_PORTS.get().getRegistryKey(), Ref.Ports.MEK_HEAT, MekHeatJeiPortTypeEntry::new);
        }
    }

    public static void init() {
        if (ModList.get().isLoaded("jei")) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(MMCompatRegistries::on);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(MMCompatRegistries::registerJeiPorts);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(MMCompatRegistries::registerJeiRecipeEntries);
        }
    }
}

