/*
 * Decompiled with CFR 0.152.
 */
package io.ticticboom.mods.mm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.ticticboom.mods.mm.Ref;
import io.ticticboom.mods.mm.client.screen.ControllerScreen;
import io.ticticboom.mods.mm.client.screen.PortScreen;
import io.ticticboom.mods.mm.compat.MMCompatRegistries;
import io.ticticboom.mods.mm.datagen.DataGenFactory;
import io.ticticboom.mods.mm.datagen.GeneratedRepoSource;
import io.ticticboom.mods.mm.datagen.gen.MMBlockStateProvider;
import io.ticticboom.mods.mm.datagen.gen.MMItemModelProvider;
import io.ticticboom.mods.mm.datagen.gen.MMLangProvider;
import io.ticticboom.mods.mm.datagen.gen.MMLootTableProvider;
import io.ticticboom.mods.mm.setup.MMRegistries;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="mm")
public class ModRoot {
    private static DataGenerator gen;
    private static boolean generated;
    public static CreativeModeTab MM_GROUP;

    public ModRoot() {
        DataGenFactory.init();
        this.registerDataGen();
        MMRegistries.register();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::clientSetup);
        try {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                MMCompatRegistries.init();
                Minecraft.m_91087_().m_91099_().addPackFinder((RepositorySource)new GeneratedRepoSource());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        MinecraftForge.EVENT_BUS.addListener(this::serverStart);
    }

    public void serverStart(ServerStartingEvent event) {
        event.getServer().m_129891_().addPackFinder((RepositorySource)new GeneratedRepoSource());
    }

    private void registerDataGen() {
        gen = DataGenFactory.create();
        gen.m_236039_(true, (DataProvider)new MMLootTableProvider(gen));
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            ExistingFileHelper efh = new ExistingFileHelper((Collection)ImmutableList.of(), (Set)ImmutableSet.of(), false, null, null);
            gen.m_236039_(true, (DataProvider)new MMBlockStateProvider(gen, efh));
            gen.m_236039_(true, (DataProvider)new MMItemModelProvider(gen, efh));
            gen.m_236039_(true, (DataProvider)new MMLangProvider(gen));
        }
    }

    public static void generate() {
        if (!generated) {
            try {
                if (!ModLoader.isLoadingStateValid()) {
                    return;
                }
                gen.m_123917_();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            generated = true;
        }
    }

    public static void injectDatapackFinder(PackRepository resourcePacks) {
        if (((Boolean)DistExecutor.unsafeRunForDist(() -> () -> resourcePacks != Minecraft.m_91087_().m_91099_(), () -> () -> true)).booleanValue()) {
            resourcePacks.addPackFinder((RepositorySource)new GeneratedRepoSource());
            Ref.LOG.info("Injecting data pack finder.");
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        for (RegistryObject entry : MMRegistries.BLOCKS.getEntries()) {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)entry.get()), layer -> layer == RenderType.m_110451_() || layer == RenderType.m_110466_());
        }
        for (RegistryObject entry : MMRegistries.MENU_TYPES.getEntries()) {
            if (entry.getId().m_135815_().endsWith("controller")) {
                MenuScreens.m_96206_((MenuType)((MenuType)entry.get()), ControllerScreen::new);
                continue;
            }
            if (!entry.getId().m_135815_().endsWith("port")) continue;
            MenuScreens.m_96206_((MenuType)((MenuType)entry.get()), PortScreen::new);
        }
    }

    static {
        generated = false;
        MM_GROUP = new CreativeModeTab("mm"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)MMRegistries.BLUEPRINT.get());
            }
        };
    }
}

