/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import snownee.lychee.PostActionTypes;
import snownee.lychee.client.core.post.CycleStatePropertyPostActionRenderer;
import snownee.lychee.client.core.post.IfPostActionRenderer;
import snownee.lychee.client.core.post.PlaceBlockPostActionRenderer;
import snownee.lychee.client.core.post.PostActionRenderer;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.dripstone_dripping.DripstoneRecipeMod;
import snownee.lychee.dripstone_dripping.client.ParticleFactories;
import snownee.lychee.util.CommonProxy;

public interface ClientProxy {
    public static final List<RecipeViewerWidgetClickListener> recipeViewerWidgetClickListeners = ObjectArrayList.of();

    public static MutableComponent getDimensionDisplayName(ResourceKey<Level> dimension) {
        String key = Util.m_137492_((String)"dimension", (ResourceLocation)dimension.m_135782_());
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        return Component.m_237113_((String)CommonProxy.capitaliseAllWords(dimension.m_135782_().m_135815_()));
    }

    public static MutableComponent getStructureDisplayName(ResourceLocation rawName) {
        String key = Util.m_137492_((String)"structure", (ResourceLocation)rawName);
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        return Component.m_237113_((String)CommonProxy.capitaliseAllWords(rawName.m_135815_()));
    }

    public static MutableComponent format(String s, Object ... objects) {
        try {
            return Component.m_237113_((String)MessageFormat.format(I18n.m_118938_((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return Component.m_237110_((String)s, (Object[])objects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInfoBadgeClickListener(RecipeViewerWidgetClickListener listener) {
        List<RecipeViewerWidgetClickListener> list = recipeViewerWidgetClickListeners;
        synchronized (list) {
            recipeViewerWidgetClickListeners.add(listener);
        }
    }

    public static boolean postInfoBadgeClickEvent(ILycheeRecipe<?> recipe, int button) {
        for (RecipeViewerWidgetClickListener listener : recipeViewerWidgetClickListeners) {
            if (!listener.onClick(recipe, button)) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(EventPriority.NORMAL, false, TextureStitchEvent.Pre.class, event -> {
            if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
                for (int i = 0; i <= 3; ++i) {
                    event.addSprite(new ResourceLocation("lychee", "particle/splash_" + i));
                }
            }
        });
        modEventBus.addListener(EventPriority.NORMAL, false, RegisterParticleProvidersEvent.class, event -> {
            event.register(DripstoneRecipeMod.DRIPSTONE_DRIPPING, ParticleFactories.Dripping::new);
            event.register(DripstoneRecipeMod.DRIPSTONE_FALLING, ParticleFactories.Falling::new);
            event.register(DripstoneRecipeMod.DRIPSTONE_SPLASH, ParticleFactories.Splash::new);
        });
    }

    public static void registerPostActionRenderers() {
        PostActionRenderer.register(PostActionTypes.DROP_ITEM, action -> action.stack);
        PostActionRenderer.register(PostActionTypes.SET_ITEM, action -> action.stack);
        PostActionRenderer.register(PostActionTypes.DROP_XP, action -> Items.f_42612_.m_7968_());
        PostActionRenderer.register(PostActionTypes.EXECUTE, action -> Items.f_42116_.m_7968_());
        PostActionRenderer.register(PostActionTypes.EXPLODE, action -> Items.f_41996_.m_7968_());
        PostActionRenderer.register(PostActionTypes.HURT, action -> Items.f_42383_.m_7968_());
        PostActionRenderer.register(PostActionTypes.IF, new IfPostActionRenderer());
        PostActionRenderer.register(PostActionTypes.PLACE, new PlaceBlockPostActionRenderer());
        PostActionRenderer.register(PostActionTypes.CYCLE_STATE_PROPERTY, new CycleStatePropertyPostActionRenderer());
    }

    @FunctionalInterface
    public static interface RecipeViewerWidgetClickListener {
        public boolean onClick(ILycheeRecipe<?> var1, int var2);
    }
}

