/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.dripstone_dripping;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.Lychee;
import snownee.lychee.RecipeTypes;
import snownee.lychee.dripstone_dripping.DripParticleHandler;
import snownee.lychee.dripstone_dripping.DripstoneRecipe;
import snownee.lychee.util.CommonProxy;

public class DripstoneRecipeMod {
    public static final Cache<Block, DripParticleHandler> particleHandlers = CacheBuilder.newBuilder().build();
    public static final ParticleType<BlockParticleOption> DRIPSTONE_DRIPPING = CommonProxy.registerParticleType((ParticleOptions.Deserializer<BlockParticleOption>)BlockParticleOption.f_123624_);
    public static final ParticleType<BlockParticleOption> DRIPSTONE_FALLING = CommonProxy.registerParticleType((ParticleOptions.Deserializer<BlockParticleOption>)BlockParticleOption.f_123624_);
    public static final ParticleType<BlockParticleOption> DRIPSTONE_SPLASH = CommonProxy.registerParticleType((ParticleOptions.Deserializer<BlockParticleOption>)BlockParticleOption.f_123624_);

    public static boolean spawnDripParticle(Level level, BlockPos blockPos, BlockState blockState) {
        BlockState sourceBlock = DripstoneRecipe.getBlockAboveStalactite(level, blockPos, blockState);
        if (sourceBlock == null || !RecipeTypes.DRIPSTONE_DRIPPING.hasSource(sourceBlock.m_60734_())) {
            return false;
        }
        FluidState sourceFluid = sourceBlock.m_60819_();
        if (sourceFluid.m_205070_(FluidTags.f_13132_) || sourceFluid.m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        if (CommonProxy.hasModdedDripParticle(sourceFluid)) {
            return false;
        }
        DripParticleHandler handler = DripstoneRecipeMod.getParticleHandler(level, sourceBlock);
        if (handler == null) {
            return false;
        }
        Vec3 vec3 = blockState.m_60824_((BlockGetter)level, blockPos);
        double e = (double)blockPos.m_123341_() + 0.5 + vec3.f_82479_;
        double f = (double)((float)(blockPos.m_123342_() + 1) - 0.6875f) - 0.0625;
        double g = (double)blockPos.m_123343_() + 0.5 + vec3.f_82481_;
        handler.addParticle(level, blockPos, sourceBlock, e, f, g);
        return true;
    }

    public static DripParticleHandler getParticleHandler(Level level, BlockState sourceBlock) {
        Block block = sourceBlock.m_60734_();
        try {
            return (DripParticleHandler)particleHandlers.get((Object)block, () -> {
                if (!CommonProxy.isPhysicalClient()) {
                    return DripParticleHandler.SIMPLE_DUMMY;
                }
                BlockState defaultState = block.m_49966_();
                int color = defaultState.m_60780_((BlockGetter)level, (BlockPos)BlockPos.f_121853_).f_76396_;
                return new DripParticleHandler.Simple(color, defaultState.m_60791_() > 4);
            });
        }
        catch (ExecutionException e) {
            Lychee.LOGGER.error("", (Throwable)e);
            return null;
        }
    }
}

