/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.crafting;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeConfig;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.core.contextual.ContextualHolder;
import snownee.lychee.core.input.ItemHolderCollection;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.input.SetItem;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.crafting.CraftingContext;
import snownee.lychee.crafting.LycheeCraftingContainer;
import snownee.lychee.fragment.Fragments;
import snownee.lychee.mixin.CraftingContainerAccess;
import snownee.lychee.mixin.CraftingMenuAccess;
import snownee.lychee.mixin.InventoryMenuAccess;
import snownee.lychee.mixin.ShapedRecipeAccess;
import snownee.lychee.util.Pair;
import snownee.lychee.util.json.JsonPointer;

public class ShapedCraftingRecipe
extends ShapedRecipe
implements ILycheeRecipe<CraftingContext> {
    public static final Cache<Class<?>, Function<AbstractContainerMenu, Pair<Vec3, Player>>> CONTAINER_WORLD_LOCATOR = CacheBuilder.newBuilder().build();
    private static final Function<AbstractContainerMenu, Pair<Vec3, Player>> FALLBACK = menu -> null;
    private final ContextualHolder conditions = new ContextualHolder();
    public boolean ghost;
    public boolean hideInRecipeViewer;
    @Nullable
    public String comment;
    @Nullable
    public String pattern;
    private List<PostAction> actions = Collections.EMPTY_LIST;
    private List<PostAction> assembling = Collections.EMPTY_LIST;

    public ShapedCraftingRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result) {
        super(id, group, width, height, ingredients, result);
    }

    private static Pair<Vec3, Player> getMenuContext(AbstractContainerMenu menu) {
        try {
            Function func = (Function)CONTAINER_WORLD_LOCATOR.get(menu.getClass(), () -> {
                for (Class<?> clazz = menu.getClass().getSuperclass(); clazz != AbstractContainerMenu.class; clazz = clazz.getSuperclass()) {
                    Function locator = (Function)CONTAINER_WORLD_LOCATOR.getIfPresent(clazz);
                    if (locator == null) continue;
                    return locator;
                }
                return FALLBACK;
            });
            return (Pair)func.apply(menu);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static CraftingContext makeContext(CraftingContainer container, Level level, int matchX, int matchY, boolean mirror) {
        AbstractContainerMenu menu = ((CraftingContainerAccess)container).getMenu();
        Pair<Vec3, Player> pair = ShapedCraftingRecipe.getMenuContext(menu);
        CraftingContext.Builder builder = new CraftingContext.Builder(level, matchX, matchY, mirror);
        if (pair != null) {
            builder.withOptionalParameter(LootContextParams.f_81460_, pair.getFirst());
            builder.withOptionalParameter(LootContextParams.f_81455_, (Entity)pair.getSecond());
        }
        CraftingContext ctx = builder.create(LycheeLootContextParamSets.CRAFTING);
        ((LycheeCraftingContainer)container).lychee$setContext(ctx);
        return ctx;
    }

    public boolean m_5818_(CraftingContainer container, Level level) {
        if (this.ghost) {
            return false;
        }
        if (level.f_46443_) {
            return super.m_5818_(container, level);
        }
        ShapedRecipeAccess access = (ShapedRecipeAccess)((Object)this);
        int i = 0;
        int j = 0;
        boolean mirror = false;
        boolean matched = false;
        block0: for (i = 0; i <= container.m_39347_() - this.m_44220_(); ++i) {
            for (j = 0; j <= container.m_39346_() - this.m_44221_(); ++j) {
                if (access.callMatches(container, i, j, true)) {
                    matched = true;
                    break block0;
                }
                if (this.m_44220_() <= 1 || !access.callMatches(container, i, j, false)) continue;
                matched = true;
                mirror = true;
                break block0;
            }
        }
        if (!matched) {
            return false;
        }
        CraftingContext ctx = ShapedCraftingRecipe.makeContext(container, level, i, j, mirror);
        boolean bl = matched = this.conditions.checkConditions(this, ctx, 1) > 0;
        if (matched) {
            ItemStack result = this.m_8043_().m_41777_();
            NonNullList ingredients = this.m_7527_();
            ItemStack[] items = new ItemStack[ingredients.size() + 1];
            int startIndex = container.m_39347_() * ctx.matchY + ctx.matchX;
            int k = 0;
            for (i = 0; i < this.m_44221_(); ++i) {
                for (j = 0; j < this.m_44220_(); ++j) {
                    items[k] = container.m_8020_(startIndex + container.m_39347_() * i + (ctx.mirror ? this.m_44220_() - j : j));
                    if (!items[k].m_41619_()) {
                        items[k] = items[k].m_41777_();
                        items[k].m_41764_(1);
                    }
                    ++k;
                }
            }
            items[ingredients.size()] = result;
            ctx.itemHolders = ItemHolderCollection.Inventory.of(ctx, items);
        }
        return matched;
    }

    public ItemStack m_5874_(CraftingContainer container) {
        CraftingContext ctx = ((LycheeCraftingContainer)container).lychee$getContext();
        if (ctx == null) {
            return ItemStack.f_41583_;
        }
        ctx.enqueueActions(this.assembling.stream(), 1, true);
        ctx.runtime.run(this, ctx);
        return ctx.m_8020_(ctx.m_6643_() - 1);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        CraftingContext ctx = ((LycheeCraftingContainer)container).lychee$getContext();
        NonNullList items = super.m_7457_((Container)container);
        if (ctx == null) {
            return items;
        }
        this.applyPostActions(ctx, 1);
        int startIndex = container.m_39347_() * ctx.matchY + ctx.matchX;
        int k = 0;
        for (int i = 0; i < this.m_44221_(); ++i) {
            for (int j = 0; j < this.m_44220_(); ++j) {
                if (ctx.itemHolders.ignoreConsumptionFlags.get(k)) {
                    items.set(startIndex + container.m_39347_() * i + (ctx.mirror ? this.m_44220_() - j : j), (Object)ctx.m_8020_(k));
                }
                ++k;
            }
        }
        return items;
    }

    @Override
    public JsonPointer defaultItemPointer() {
        return RESULT;
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        int size = this.m_7527_().size();
        if (pointer.size() == 1 && pointer.getString(0).equals("result")) {
            return IntList.of((int)size);
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("key")) {
            String key = pointer.getString(1);
            if (key.length() != 1) {
                return IntList.of();
            }
            IntArrayList list = IntArrayList.of();
            int cp = key.codePointAt(0);
            int l = this.pattern.length();
            for (int i = 0; i < l; ++i) {
                if (cp != this.pattern.codePointAt(i)) continue;
                list.add(i);
            }
            return list;
        }
        return IntList.of((int)size);
    }

    @Override
    public Stream<PostAction> getPostActions() {
        return this.actions.stream();
    }

    @Override
    public Stream<PostAction> getAllActions() {
        return Stream.concat(this.getPostActions(), this.assembling.stream());
    }

    @Override
    public ContextualHolder getContextualHolder() {
        return this.conditions;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void addPostAction(PostAction action) {
        Objects.requireNonNull(action);
        if (action instanceof SetItem) {
            SetItem setItem = (SetItem)action;
            if (this.getItemIndexes(setItem.target).contains(this.m_7527_().size())) {
                throw new JsonSyntaxException("Can't set item to the result in \"post\", use \"assembling\".");
            }
        }
        if (this.actions == Collections.EMPTY_LIST) {
            this.actions = Lists.newArrayList();
        }
        this.actions.add(action);
    }

    public void addAssemblingAction(PostAction action) {
        Objects.requireNonNull(action);
        if (action instanceof SetItem) {
            SetItem setItem = (SetItem)action;
            IntList intList = this.getItemIndexes(setItem.target);
            if (!intList.isEmpty() && !intList.contains(this.m_7527_().size())) {
                throw new JsonSyntaxException("Can't set item to the ingredients in \"assembling\", use \"post\".");
            }
        }
        if (this.assembling == Collections.EMPTY_LIST) {
            this.assembling = Lists.newArrayList();
        }
        this.assembling.add(action);
    }

    @Override
    public boolean showInRecipeViewer() {
        return !this.hideInRecipeViewer;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializers.CRAFTING;
    }

    public boolean m_5598_() {
        return !this.conditions.getConditions().isEmpty() || !this.assembling.isEmpty();
    }

    @Override
    public boolean isActionPath(JsonPointer pointer) {
        if (pointer.isRoot()) {
            return false;
        }
        String token = pointer.getString(0);
        return "assembling".equals(token) || "post".equals(token);
    }

    @Override
    public Map<JsonPointer, List<PostAction>> getActionGroups() {
        return Map.of(POST, this.actions, new JsonPointer("/assembling"), this.assembling);
    }

    static {
        CONTAINER_WORLD_LOCATOR.put(CraftingMenu.class, menu -> {
            CraftingMenuAccess access = (CraftingMenuAccess)menu;
            return Pair.of((Vec3)access.getAccess().m_39299_((level, pos) -> Vec3.m_82512_((Vec3i)pos), (Object)access.getPlayer().m_20182_()), access.getPlayer());
        });
        CONTAINER_WORLD_LOCATOR.put(InventoryMenu.class, menu -> {
            InventoryMenuAccess access = (InventoryMenuAccess)menu;
            return Pair.of(access.getOwner().m_20182_(), access.getOwner());
        });
    }

    public static class Serializer
    implements RecipeSerializer<ShapedCraftingRecipe> {
        private static ShapedCraftingRecipe fromNormal(ShapedRecipe recipe) {
            return new ShapedCraftingRecipe(recipe.m_6423_(), recipe.m_6076_(), recipe.m_44220_(), recipe.m_44221_(), (NonNullList<Ingredient>)recipe.m_7527_(), recipe.m_8043_());
        }

        public ShapedCraftingRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
            Fragments.INSTANCE.process((JsonElement)jsonObject);
            ShapedCraftingRecipe recipe = Serializer.fromNormal((ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(id, jsonObject));
            recipe.hideInRecipeViewer = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"hide_in_viewer", (boolean)false);
            recipe.ghost = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"ghost", (boolean)false);
            recipe.comment = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"comment", null);
            StringBuilder sb = new StringBuilder();
            StreamSupport.stream(jsonObject.getAsJsonArray("pattern").spliterator(), false).map(JsonElement::getAsString).forEach(sb::append);
            recipe.pattern = sb.toString();
            recipe.conditions.parseConditions(jsonObject.get("contextual"));
            PostAction.parseActions(jsonObject.get("post"), recipe::addPostAction);
            PostAction.parseActions(jsonObject.get("assembling"), recipe::addAssemblingAction);
            ILycheeRecipe.processActions(recipe, jsonObject);
            return recipe;
        }

        public ShapedCraftingRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            if (LycheeConfig.debug) {
                Lychee.LOGGER.debug("Read recipe: {}", (Object)id);
            }
            ShapedCraftingRecipe recipe = Serializer.fromNormal((ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(id, buf));
            recipe.hideInRecipeViewer = buf.readBoolean();
            if (recipe.hideInRecipeViewer) {
                return recipe;
            }
            recipe.conditions.conditionsFromNetwork(buf);
            LycheeRecipe.Serializer.actionsFromNetwork(buf, recipe::addPostAction);
            recipe.comment = buf.m_130277_();
            recipe.pattern = buf.m_130277_();
            return recipe;
        }

        public void toNetwork(FriendlyByteBuf buf, ShapedCraftingRecipe recipe) {
            if (LycheeConfig.debug) {
                Lychee.LOGGER.debug("Write recipe: {}", (Object)recipe.m_6423_());
            }
            RecipeSerializer.f_44076_.m_6178_(buf, (Recipe)recipe);
            buf.writeBoolean(recipe.hideInRecipeViewer);
            if (recipe.hideInRecipeViewer) {
                return;
            }
            recipe.conditions.conditionsToNetwork(buf);
            LycheeRecipe.Serializer.actionsToNetwork(buf, recipe.actions);
            buf.m_130070_(Strings.nullToEmpty((String)recipe.comment));
            buf.m_130070_(Strings.nullToEmpty((String)recipe.pattern));
        }
    }
}

