/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.util.RecipeMatcher;

public abstract class ItemShapelessRecipe<T extends ItemShapelessRecipe<T>>
extends LycheeRecipe<ItemShapelessContext>
implements Comparable<T> {
    public static final int MAX_INGREDIENTS = 27;
    protected NonNullList<Ingredient> ingredients = NonNullList.m_122779_();

    public ItemShapelessRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(ItemShapelessContext ctx, Level pLevel) {
        int[] amount;
        if (ctx.totalItems < this.ingredients.size()) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return true;
        }
        List<ItemEntity> itemEntities = ctx.itemEntities.stream().filter($ -> this.ingredients.stream().anyMatch(ingredient -> ingredient.test($.m_32055_()))).limit(27L).toList();
        List<ItemStack> items = itemEntities.stream().map(ItemEntity::m_32055_).toList();
        Optional<RecipeMatcher<ItemStack>> match = RecipeMatcher.findMatches(items, this.ingredients, amount = items.stream().mapToInt(ItemStack::m_41613_).toArray());
        if (match.isEmpty()) {
            return false;
        }
        ctx.filteredItems = itemEntities;
        ctx.setMatch(match.get());
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Override
    public int compareTo(T that) {
        int i = Integer.compare(this.getMaxRepeats().m_55327_() ? 1 : 0, ((LycheeRecipe)that).getMaxRepeats().m_55327_() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.m_5598_() ? 1 : 0, that.m_5598_() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = -Integer.compare(this.ingredients.size(), ((ItemShapelessRecipe)that).ingredients.size());
        if (i != 0) {
            return i;
        }
        return this.m_6423_().compareTo(((LycheeRecipe)that).m_6423_());
    }

    public static class Serializer<T extends ItemShapelessRecipe<T>>
    extends LycheeRecipe.Serializer<T> {
        public Serializer(Function<ResourceLocation, T> factory) {
            super(factory);
        }

        @Override
        public void fromJson(T pRecipe, JsonObject pSerializedRecipe) {
            if (pSerializedRecipe.has("item_in")) {
                JsonElement itemIn = pSerializedRecipe.get("item_in");
                if (itemIn.isJsonArray()) {
                    itemIn.getAsJsonArray().forEach($ -> pRecipe.ingredients.add((Object)Ingredient.m_43917_((JsonElement)$)));
                } else {
                    ((ItemShapelessRecipe)pRecipe).ingredients.add((Object)Ingredient.m_43917_((JsonElement)itemIn));
                }
            }
            Preconditions.checkArgument((((ItemShapelessRecipe)pRecipe).ingredients.size() <= 27 ? 1 : 0) != 0, (String)"Ingredients cannot be more than %s", (int)27);
        }

        @Override
        public void fromNetwork(T pRecipe, FriendlyByteBuf pBuffer) {
            pBuffer.m_236838_(i -> pRecipe.ingredients, Ingredient::m_43940_);
        }

        @Override
        public void toNetwork0(FriendlyByteBuf pBuffer, T pRecipe) {
            pBuffer.m_236828_(((ItemShapelessRecipe)pRecipe).ingredients, (b, i) -> i.m_43923_(b));
        }
    }
}

