/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post.input;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.Reference;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.json.JsonPointer;

public class SetItem
extends PostAction {
    public final ItemStack stack;
    public final Reference target;

    public SetItem(ItemStack stack, Reference target) {
        this.stack = stack;
        this.target = target;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.SET_ITEM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        for (Integer index : indexes) {
            CompoundTag tag = ctx.m_8020_(index).m_41783_();
            ItemStack stack = this.path == null ? this.stack.m_41777_() : ItemStack.m_41712_((CompoundTag)CommonProxy.jsonToTag(new JsonPointer(this.path).find((JsonElement)ctx.json)));
            ctx.m_6836_(index, stack);
            if (tag != null && !stack.m_41619_()) {
                ctx.m_8020_(index).m_41784_().m_128391_(tag);
            }
            ctx.itemHolders.ignoreConsumptionFlags.set(index);
        }
    }

    @Override
    public Component getDisplayName() {
        return this.stack.m_41786_();
    }

    @Override
    public List<ItemStack> getItemOutputs() {
        return List.of(this.stack);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        Preconditions.checkArgument((recipe.getItemIndexes(this.target).size() > 0 ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    @Override
    public JsonElement provideJsonInfo(ILycheeRecipe<?> recipe, JsonPointer pointer, JsonObject recipeObject) {
        this.path = pointer.toString();
        return CommonProxy.tagToJson(this.stack.m_41739_(new CompoundTag()));
    }

    public static class Type
    extends PostActionType<SetItem> {
        @Override
        public SetItem fromJson(JsonObject o) {
            ItemStack stack = "minecraft:air".equals(Objects.toString(ResourceLocation.m_135820_((String)o.get("item").getAsString()))) ? ItemStack.f_41583_ : ShapedRecipe.m_151274_((JsonObject)o);
            return new SetItem(stack, Reference.fromJson(o, "target"));
        }

        @Override
        public void toJson(SetItem action, JsonObject o) {
            CommonProxy.itemstackToJson(action.stack, o);
            Reference.toJson(action.target, o, "target");
        }

        @Override
        public SetItem fromNetwork(FriendlyByteBuf buf) {
            return new SetItem(buf.m_130267_(), Reference.fromNetwork(buf));
        }

        @Override
        public void toNetwork(SetItem action, FriendlyByteBuf buf) {
            buf.m_130055_(action.stack);
            Reference.toNetwork(action.target, buf);
        }
    }
}

