/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post.input;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeConfig;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.ActionRuntime;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.json.JsonPatch;
import snownee.lychee.util.json.JsonPointer;

public class NBTPatch
extends PostAction {
    private final JsonPatch patch;

    public NBTPatch(JsonPatch patch) {
        this.patch = patch;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.NBT_PATCH;
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
    }

    @Override
    public void preApply(ILycheeRecipe<?> recipe, LycheeContext ctx, ILycheeRecipe.NBTPatchContext patchContext) {
        Preconditions.checkNotNull((Object)ctx.json);
        JsonPointer from = this.patch.from;
        if (from != null) {
            from = patchContext.convertPath(from, (first, second) -> "/" + recipe.getItemIndexes(new JsonPointer((String)first)).getInt(0) + second);
        }
        JsonPatch patchClone = new JsonPatch(this.patch.op, this.patch.path, from, this.patch.value);
        try {
            if (recipe.isActionPath(this.patch.path)) {
                patchClone.apply((JsonElement)ctx.json);
            } else {
                for (Integer index : recipe.getItemIndexes(patchContext.convertPath(this.patch.path, (first, second) -> first))) {
                    patchClone.path = patchContext.convertPath(this.patch.path, (first, second) -> "/" + index + second);
                    patchClone.apply((JsonElement)ctx.json);
                    if (!LycheeConfig.debug) continue;
                    Lychee.LOGGER.info(ctx.json.toString());
                }
            }
        }
        catch (Exception e) {
            if (this.patch.op == JsonPatch.Type.test) {
                ctx.runtime.state = ActionRuntime.State.STOPPED;
            }
            Lychee.LOGGER.error("Ctx json: " + ctx.json);
            Lychee.LOGGER.error("Action json: " + this.toJson());
            throw e;
        }
    }

    @Override
    public void getUsedPointers(ILycheeRecipe<?> recipe, Consumer<JsonPointer> consumer) {
        consumer.accept(this.patch.path);
        if (this.patch.from != null) {
            consumer.accept(this.patch.from);
        }
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        Preconditions.checkArgument((patchContext.countTargets(recipe, this.patch.path) > 0 ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.patch.path);
        if (this.patch.from != null) {
            int size = patchContext.countTargets(recipe, this.patch.from);
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"No source found for %s", (Object)this.patch.from);
            Preconditions.checkArgument((size == 1 ? 1 : 0) != 0, (String)"Ambiguous source for %s", (Object)this.patch.from);
        }
    }

    @Override
    public boolean preventSync() {
        return true;
    }

    public static class Type
    extends PostActionType<NBTPatch> {
        @Override
        public NBTPatch fromJson(JsonObject o) {
            JsonPatch patch = JsonPatch.parse(o);
            Preconditions.checkNotNull((Object)patch);
            return new NBTPatch(patch);
        }

        @Override
        public void toJson(NBTPatch action, JsonObject o) {
            o.add("patch", (JsonElement)action.patch.toJson());
        }

        @Override
        public NBTPatch fromNetwork(FriendlyByteBuf buf) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void toNetwork(NBTPatch action, FriendlyByteBuf buf) {
            throw new UnsupportedOperationException();
        }
    }
}

