/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.rei.category;

import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import snownee.lychee.block_crushing.BlockCrushingContext;
import snownee.lychee.block_crushing.BlockCrushingRecipe;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.JEIREI;
import snownee.lychee.compat.rei.REICompat;
import snownee.lychee.compat.rei.ReactiveWidget;
import snownee.lychee.compat.rei.category.BaseREICategory;
import snownee.lychee.compat.rei.display.BaseREIDisplay;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.CommonProxy;

public class BlockCrushingRecipeCategory
extends BaseREICategory<BlockCrushingContext, BlockCrushingRecipe, BaseREIDisplay<BlockCrushingRecipe>> {
    public static final Rect2i fallingBlockRect = new Rect2i(0, -35, 20, 35);
    public static final Rect2i landingBlockRect = new Rect2i(0, 0, 20, 20);

    public BlockCrushingRecipeCategory(LycheeRecipeType<BlockCrushingContext, BlockCrushingRecipe> recipeType) {
        super(recipeType);
    }

    @Override
    public int getDisplayWidth(BaseREIDisplay<BlockCrushingRecipe> display) {
        return this.getRealWidth();
    }

    @Override
    public int getRealWidth() {
        return 170;
    }

    @Override
    public List<Widget> setupDisplay(BaseREIDisplay<BlockCrushingRecipe> display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - this.getRealWidth() / 2, bounds.getY() + 4);
        BlockCrushingRecipe recipe = (BlockCrushingRecipe)display.recipe;
        List<Widget> widgets = super.setupDisplay(display, bounds);
        this.drawInfoBadge(widgets, display, startPoint);
        widgets.add(Widgets.createDrawableWidget((helper, matrixStack, mouseX, mouseY, delta) -> {
            int x = recipe.m_7527_().isEmpty() ? 41 : 77;
            boolean anyLandingBlock = recipe.getLandingBlock() == BlockPredicate.f_17902_;
            int y = anyLandingBlock ? 45 : 33;
            float ticks = (float)(System.currentTimeMillis() % 2000L) / 1000.0f;
            ticks = Math.min(1.0f, ticks);
            ticks = ticks * ticks * ticks * ticks;
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)startPoint.x, (double)startPoint.y, 0.0);
            BlockState landingBlock = this.getLandingBlock(recipe);
            if (landingBlock.m_60791_() < 5) {
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)x + 10.5, (double)(y + (anyLandingBlock ? 1 : 16)), 0.0);
                float shadow = 0.6f;
                if (anyLandingBlock) {
                    shadow = 0.2f + ticks * 0.2f;
                }
                matrixStack.m_85841_(shadow, shadow, shadow);
                matrixStack.m_85837_(-26.0, -5.5, 0.0);
                AllGuiTextures.JEI_SHADOW.render(matrixStack, 0, 0);
                matrixStack.m_85849_();
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)x, (double)(y - 13), 0.0);
            ((RenderElement)GuiGameElement.of(this.getFallingBlock(recipe)).scale(15.0).atLocal(0.0, (double)ticks * 1.3 - 1.3, 2.0).rotateBlock(20.0, 225.0, 0.0).lighting(JEIREI.BLOCK_LIGHTING).at(0.0f, 0.0f, 300.0f)).render(matrixStack);
            if (!landingBlock.m_60795_()) {
                GuiGameElement.of(landingBlock).scale(15.0).atLocal(0.0, 1.0, 2.0).rotateBlock(20.0, 225.0, 0.0).lighting(JEIREI.BLOCK_LIGHTING).render(matrixStack);
            }
            matrixStack.m_85849_();
            matrixStack.m_85849_();
        }));
        int xCenter = bounds.getCenterX();
        int y = recipe.m_7527_().size() > 9 || recipe.showingActionsCount() > 9 ? 26 : 28;
        this.ingredientGroup(widgets, startPoint, recipe, xCenter - 45 - startPoint.x, y);
        this.actionGroup(widgets, startPoint, recipe, xCenter + 50 - startPoint.x, y);
        int x = recipe.m_7527_().isEmpty() ? 41 : 77;
        y = recipe.getLandingBlock() == BlockPredicate.f_17902_ ? 45 : 33;
        fallingBlockRect.m_173049_(x, y - 35);
        landingBlockRect.m_173049_(x, y);
        ReactiveWidget reactive = new ReactiveWidget(REICompat.offsetRect(startPoint, fallingBlockRect));
        reactive.setTooltipFunction($ -> {
            List<Component> list = BlockPredicateHelper.getTooltips(this.getFallingBlock(recipe), recipe.getBlock());
            return list.toArray(new Component[0]);
        });
        reactive.setOnClick(($, button) -> this.clickBlock(this.getFallingBlock(recipe), (int)button));
        widgets.add((Widget)reactive);
        if (recipe.getLandingBlock() != BlockPredicate.f_17902_) {
            reactive = new ReactiveWidget(REICompat.offsetRect(startPoint, landingBlockRect));
            reactive.setTooltipFunction($ -> {
                List<Component> list = BlockPredicateHelper.getTooltips(this.getLandingBlock(recipe), recipe.getLandingBlock());
                return list.toArray(new Component[0]);
            });
            reactive.setOnClick(($, button) -> this.clickBlock(this.getLandingBlock(recipe), (int)button));
            widgets.add((Widget)reactive);
        }
        return widgets;
    }

    private BlockState getFallingBlock(BlockCrushingRecipe recipe) {
        return CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getBlock()), Blocks.f_50322_.m_49966_(), 2000);
    }

    private BlockState getLandingBlock(BlockCrushingRecipe recipe) {
        return CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(recipe.getLandingBlock()), Blocks.f_50016_.m_49966_(), 2000);
    }

    @Override
    public Renderer createIcon(List<BlockCrushingRecipe> recipes) {
        return EntryStacks.of((ItemLike)Items.f_42146_);
    }
}

