/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.core.post;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import snownee.lychee.core.contextual.ContextualHolder;
import snownee.lychee.core.def.BoundsHelper;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.post.RandomSelect;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;

public interface PostActionRenderer<T extends PostAction> {
    public static final Map<PostActionType<?>, PostActionRenderer<?>> RENDERERS = Maps.newHashMap();

    public static <T extends PostAction> PostActionRenderer<T> of(PostAction action) {
        return Objects.requireNonNull(RENDERERS.get(action.getType()));
    }

    public static <T extends PostAction> void register(PostActionType<T> type, PostActionRenderer<T> renderer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(renderer);
        RENDERERS.put(type, renderer);
    }

    public static List<Component> getTooltipsFromRandom(RandomSelect randomSelect, PostAction child) {
        int c;
        ArrayList list;
        int index = Arrays.asList(randomSelect.entries).indexOf(child);
        ArrayList arrayList = list = randomSelect.entries.length == 1 && randomSelect.emptyWeight == 0 ? Lists.newArrayList((Object[])new Component[]{randomSelect.getDisplayName()}) : PostActionRenderer.of(child).getBaseTooltips(child);
        if (index == -1) {
            return list;
        }
        if (randomSelect.entries.length > 1 || randomSelect.emptyWeight > 0) {
            String chance = CommonProxy.chance((float)randomSelect.weights[index] / (float)randomSelect.totalWeight);
            if (randomSelect.rolls == IntBoundsHelper.ONE) {
                list.add(Component.m_237110_((String)"tip.lychee.randomChance.one", (Object[])new Object[]{chance}).m_130940_(ChatFormatting.YELLOW));
            } else {
                list.add(Component.m_237110_((String)"tip.lychee.randomChance", (Object[])new Object[]{chance, BoundsHelper.getDescription(randomSelect.rolls)}).m_130940_(ChatFormatting.YELLOW));
            }
        }
        if ((c = randomSelect.showingConditionsCount() + child.showingConditionsCount()) > 0) {
            list.add(ClientProxy.format("contextual.lychee", c).m_130940_(ChatFormatting.GRAY));
        }
        Minecraft mc = Minecraft.m_91087_();
        randomSelect.getConditionTooltips(list, 0, (Level)mc.f_91073_, (Player)mc.f_91074_);
        child.getConditionTooltips(list, 0, (Level)mc.f_91073_, (Player)mc.f_91074_);
        return list;
    }

    default public void render(T action, PoseStack poseStack, int x, int y) {
    }

    default public List<Component> getBaseTooltips(T action) {
        return Lists.newArrayList((Object[])new Component[]{((PostAction)action).getDisplayName()});
    }

    default public List<Component> getTooltips(T action) {
        List<Component> list = this.getBaseTooltips(action);
        int c = ((ContextualHolder)action).showingConditionsCount();
        if (c > 0) {
            list.add((Component)ClientProxy.format("contextual.lychee", c).m_130940_(ChatFormatting.GRAY));
        }
        Minecraft mc = Minecraft.m_91087_();
        ((ContextualHolder)action).getConditionTooltips(list, 0, (Level)mc.f_91073_, (Player)mc.f_91074_);
        return list;
    }
}

