/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.post.PostActionType;

public final class LycheeRegistries {
    public static MappedRegistry<ContextualConditionType<?>> CONTEXTUAL;
    public static MappedRegistry<PostActionType<?>> POST_ACTION;

    public static void init(NewRegistryEvent event) {
        event.create(LycheeRegistries.register("contextual"), v -> {
            CONTEXTUAL = new MappedRegistry(v);
        });
        event.create(LycheeRegistries.register("post_action"), v -> {
            POST_ACTION = new MappedRegistry(v);
        });
    }

    private static <T> RegistryBuilder<T> register(String name) {
        return new RegistryBuilder().setName(new ResourceLocation("lychee", name));
    }

    public record MappedRegistry<T>(IForgeRegistry<T> registry) {
        public ResourceKey<Registry<T>> key() {
            return this.registry.getRegistryKey();
        }

        public void register(ResourceLocation id, T t) {
            this.registry.register(id, t);
        }

        public T get(ResourceLocation key) {
            return (T)this.registry.getValue(key);
        }

        public ResourceLocation getKey(T t) {
            return this.registry.getKey(t);
        }
    }
}

