/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.base.decoration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.level.material.Material;
import org.moddingx.libx.base.decoration.DecoratedBlock;
import org.moddingx.libx.base.decoration.DecorationType;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;

public class DecorationContext {
    public static final DecorationContext GENERIC = new DecorationContext("generic", BaseMaterial.GENERIC, DecorationType.BASE, DecorationType.SLAB, DecorationType.STAIRS);
    public static final DecorationContext PLANKS = new DecorationContext("planks", BaseMaterial.WOOD, DecorationType.BASE, DecorationType.SLAB, DecorationType.STAIRS, DecorationType.FENCE, DecorationType.FENCE_GATE, DecorationType.WOOD_BUTTON, DecorationType.WOOD_PRESSURE_PLATE, DecorationType.DOOR, DecorationType.TRAPDOOR, DecorationType.SIGN);
    public static final DecorationContext STONE = new DecorationContext("stone", BaseMaterial.STONE, DecorationType.BASE, DecorationType.SLAB, DecorationType.STAIRS, DecorationType.WALL, DecorationType.STONE_BUTTON, DecorationType.STONE_PRESSURE_PLATE);
    private final String name;
    private final BaseMaterial baseMaterial;
    private final Map<String, DecorationType<?>> types;
    private final Set<DecorationType<?>> typeSet;

    public DecorationContext(String name, BaseMaterial baseMaterial, DecorationType<?> ... types) {
        this.name = name;
        this.baseMaterial = baseMaterial;
        HashMap typeMap = new HashMap();
        for (DecorationType<?> type : types) {
            String typeName = type.name();
            if (typeName.isEmpty() && type != DecorationType.BASE) {
                throw new IllegalArgumentException("Only the base decoration type may have an empty name.");
            }
            if (typeMap.containsKey(typeName)) {
                throw new IllegalArgumentException("A decoration context can't have multiple types with the same name.");
            }
            typeMap.put(typeName, type);
        }
        if (!typeMap.containsKey("") || typeMap.get("") != DecorationType.BASE) {
            throw new IllegalArgumentException("Can't create decoration context without the base type.");
        }
        this.types = ImmutableMap.copyOf(typeMap);
        this.typeSet = ImmutableSet.copyOf(this.types.values());
    }

    public BaseMaterial baseMaterial() {
        return this.baseMaterial;
    }

    public boolean has(DecorationType<?> type) {
        if (type == DecorationType.BASE) {
            return true;
        }
        String name = type.name();
        return this.types.containsKey(name) && this.types.get(name) == type;
    }

    public Set<DecorationType<?>> types() {
        return this.typeSet;
    }

    public RegistrationInfo register(final ModX mod, final DecoratedBlock block) {
        ImmutableMap.Builder elementMap = ImmutableMap.builder();
        ImmutableMap.Builder registerMap = ImmutableMap.builder();
        for (final Map.Entry<String, DecorationType<?>> entry : this.types.entrySet()) {
            final DecorationType.DecorationElement<?, ?> element = entry.getValue().element(mod, this, block);
            Objects.requireNonNull(element.element(), "DecorationType registered a null element: " + entry.getKey() + " - " + entry.getValue());
            elementMap.put(entry.getValue(), element);
            if (entry.getKey().isEmpty()) continue;
            registerMap.put((Object)entry.getKey(), (Object)new Registerable(){

                @Override
                public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
                    element.registerTo(builder);
                    ((DecorationType)entry.getValue()).registerAdditional(mod, DecorationContext.this, block, element.element(), ctx, builder);
                }
            });
        }
        return new RegistrationInfo((Map<DecorationType<?>, DecorationType.DecorationElement<?, ?>>)elementMap.build(), (Map<String, Registerable>)registerMap.build());
    }

    public String toString() {
        return this.name + "[" + this.types.values().stream().map(DecorationType::name).filter(s -> !s.isEmpty()).sorted().collect(Collectors.joining(",")) + "]";
    }

    public static enum BaseMaterial {
        GENERIC(null),
        WOOD(Material.f_76320_),
        STONE(Material.f_76278_),
        MINERAL(Material.f_76279_);

        @Nullable
        public final Material material;

        private BaseMaterial(Material material) {
            this.material = material;
        }
    }

    public record RegistrationInfo(Map<DecorationType<?>, DecorationType.DecorationElement<?, ?>> elementMap, Map<String, Registerable> registerMap) {
    }
}

