/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import giselle.jei_mekanism_multiblocks.client.GuiHelper;
import giselle.jei_mekanism_multiblocks.client.IRecipeLogicStateListener;
import giselle.jei_mekanism_multiblocks.client.gui.ContainerWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.gui.LabelWidget;
import giselle.jei_mekanism_multiblocks.client.gui.ListWidget;
import giselle.jei_mekanism_multiblocks.client.gui.TabButtonWidget;
import giselle.jei_mekanism_multiblocks.client.gui.TextAlignment;
import giselle.jei_mekanism_multiblocks.client.jei.CostList;
import giselle.jei_mekanism_multiblocks.client.jei.CostWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ListLineWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public abstract class MultiblockWidget
extends ContainerWidget {
    private boolean initialzed = false;
    protected final ListWidget configsList;
    protected final TabButtonWidget costsButton;
    protected final TabButtonWidget resultsButton;
    protected final CostList costsList;
    protected final ListLineWidget resultsList;
    protected IntSliderWithButtons widthWidget;
    protected IntSliderWithButtons lengthWidget;
    protected IntSliderWithButtons heightWidget;
    private boolean needNotifyStateChange;

    public MultiblockWidget() {
        super(0, 0, 0, 0);
        LabelWidget specsLabel = new LabelWidget(0, 0, 100, 10, (Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.specs"), TextAlignment.LEFT);
        specsLabel.setFGColor(0x3F3F3F);
        specsLabel.setShadow(false);
        this.addChild(specsLabel);
        this.configsList = new ListWidget(0, 10, 100, 110, 10);
        this.addChild(this.configsList);
        this.configsList.setItemsPadding(2);
        this.configsList.setItemOffset(2);
        this.costsButton = new TabButtonWidget(99, 0, 41, 10, (Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.costs"));
        this.addChild(this.costsButton);
        this.costsButton.addPressHandler(this::onCostsButtonClick);
        this.resultsButton = new TabButtonWidget(139, 0, 41, 10, (Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.results"));
        this.addChild(this.resultsButton);
        this.resultsButton.addPressHandler(this::onResultsButtonClick);
        this.costsList = new CostList(100, 10, 80, 110, 20);
        this.addChild(this.costsList);
        this.costsList.setItemsTop(2);
        this.costsList.setItemOffset(1);
        this.resultsList = new ListLineWidget(100, 10, 80, 110, 20);
        this.addChild(this.resultsList);
        this.resultsList.setItemsPadding(2);
        this.resultsList.setItemOffset(1);
        this.createSpecDimension();
        ArrayList otherWidgets = new ArrayList();
        this.collectOtherConfigs(otherWidgets::add);
        if (otherWidgets.size() > 0) {
            otherWidgets.forEach(this.configsList::addChild);
        }
        this.needNotifyStateChange = true;
        this.showRightPanel(true);
    }

    private void showRightPanel(boolean costs) {
        boolean results = !costs;
        this.costsButton.setSelected(costs);
        this.resultsButton.setSelected(results);
        this.costsList.f_93624_ = costs;
        this.resultsList.f_93624_ = results;
    }

    private void onCostsButtonClick(AbstractButton button) {
        this.showRightPanel(true);
    }

    private void onResultsButtonClick(AbstractButton button) {
        this.showRightPanel(false);
    }

    protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
    }

    private void createSpecDimension() {
        ArrayList<IntSliderWithButtons> widgets = new ArrayList<IntSliderWithButtons>();
        this.widthWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.width", this.createDimensionSlider(0, this.getDimensionWidthMin(), this.getDimensionWidthMax()));
        widgets.add(this.widthWidget);
        ((IntSliderWidget)((Object)this.widthWidget.getSlider())).addValueChangeHanlder(this::onDimensionWidthChanged);
        this.lengthWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.length", this.createDimensionSlider(1, this.getDimensionLengthMin(), this.getDimensionLengthMax()));
        widgets.add(this.lengthWidget);
        ((IntSliderWidget)((Object)this.lengthWidget.getSlider())).addValueChangeHanlder(this::onDimensionLengthChanged);
        this.heightWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.height", this.createDimensionSlider(2, this.getDimensionHeightMin(), this.getDimensionHeightMax()));
        widgets.add(this.heightWidget);
        ((IntSliderWidget)((Object)this.heightWidget.getSlider())).addValueChangeHanlder(this::onDimensionHeightChanged);
        List<IntSliderWithButtons> list = widgets.stream().filter(w -> this.isUseDimensionWidget((IntSliderWithButtons)((Object)w)) && ((IntSliderWidget)((Object)((Object)w.getSlider()))).getMinValue() < ((IntSliderWidget)((Object)((Object)w.getSlider()))).getMaxValue()).toList();
        if (list.size() > 0) {
            list.forEach(this.configsList::addChild);
        }
    }

    protected IntSliderWidget createDimensionSlider(int index, int min, int max) {
        return new IntSliderWidget(0, 0, 0, 0, (Component)Component.m_237119_(), min, min, max);
    }

    protected boolean isUseDimensionWidget(IntSliderWithButtons widget) {
        return true;
    }

    protected void onDimensionWidthChanged(int width) {
        this.onDimensionChanged();
    }

    protected void onDimensionLengthChanged(int length) {
        this.onDimensionChanged();
    }

    protected void onDimensionHeightChanged(int height) {
        this.onDimensionChanged();
    }

    protected void onDimensionChanged() {
        this.markNeedUpdate();
    }

    public List<ItemStack> getCosts() {
        return this.costsList.getCosts();
    }

    private void updateCosts() {
        ArrayList<CostWidget> costs = new ArrayList<CostWidget>();
        this.collectCost(w -> {
            costs.add(w);
            return w;
        });
        this.costsList.updateCosts(costs);
    }

    protected void collectCost(ICostConsumer consumer) {
    }

    private void updateResults() {
        ArrayList costs = new ArrayList();
        this.collectResult(costs::add);
        this.resultsList.clearChildren();
        costs.forEach(this.resultsList::addChild);
    }

    protected void collectResult(Consumer<AbstractWidget> consumer) {
    }

    @Override
    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTicks) {
        int lineTop = this.f_93621_ + this.configsList.f_93621_;
        GuiHelper.fillRectagleBlack(pPoseStack, this.f_93620_, lineTop, this.configsList.m_5711_(), 1);
        if (!this.costsButton.isSelected()) {
            GuiHelper.fillRectagleBlack(pPoseStack, this.f_93620_ + this.costsButton.f_93620_, lineTop, this.costsButton.m_5711_(), 1);
        }
        if (!this.resultsButton.isSelected()) {
            GuiHelper.fillRectagleBlack(pPoseStack, this.f_93620_ + this.resultsButton.f_93620_, lineTop, this.resultsButton.m_5711_(), 1);
        }
        GuiHelper.fillRectagleBlack(pPoseStack, this.f_93620_, this.f_93621_ + this.configsList.f_93621_, 1, this.f_93619_ - this.configsList.f_93621_);
        GuiHelper.fillRectagleBlack(pPoseStack, this.f_93620_, this.f_93621_ + this.f_93619_ - 1, this.f_93618_, 1);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTicks);
        if (this.needNotifyStateChange) {
            this.needNotifyStateChange = false;
            this.updateAll();
            this.notifyStateChange();
        }
    }

    public void initialize() {
        if (this.initialzed) {
            return;
        }
        this.initialzed = true;
        this.updateAll();
    }

    private void updateAll() {
        this.updateResults();
        this.updateCosts();
    }

    public Optional<Object> getIngredientUnderMouse(double pMouseX, double pMouseY) {
        return this.costsList.getIngredientUnderMouse(this.toChildX(pMouseX), this.toChildY(pMouseY));
    }

    public void markNeedUpdate() {
        this.needNotifyStateChange = true;
    }

    private void notifyStateChange() {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen instanceof IRecipeLogicStateListener) {
            IRecipeLogicStateListener listener = (IRecipeLogicStateListener)screen;
            listener.jei_mekanism_multiblocks$onStateChange();
        }
    }

    public int getDimensionVolume() {
        Vec3i dimension = this.getDimension();
        return dimension.m_123341_() * dimension.m_123342_() * dimension.m_123343_();
    }

    public int getDimensionCornerBlocks() {
        Vec3i innerDimension = this.getDimensionInner();
        return 8 + innerDimension.m_123341_() * 4 + innerDimension.m_123343_() * 4 + innerDimension.m_123342_() * 4;
    }

    public int getDimensionSideBlocks() {
        Vec3i innerDimension = this.getDimensionInner();
        return innerDimension.m_123341_() * innerDimension.m_123343_() * 2 + innerDimension.m_123341_() * innerDimension.m_123342_() * 2 + innerDimension.m_123343_() * innerDimension.m_123342_() * 2;
    }

    public int getDimensionCasingBlocks() {
        return this.getDimensionCornerBlocks() + this.getDimensionSideBlocks();
    }

    public int getCornerBlocks() {
        return this.getDimensionCornerBlocks();
    }

    public int getSideBlocks() {
        return this.getDimensionSideBlocks();
    }

    public int getDimensionInnerVolume() {
        Vec3i inner = this.getDimensionInner();
        return inner.m_123341_() * inner.m_123342_() * inner.m_123343_();
    }

    public Vec3i getDimensionInner() {
        int innerWidth = this.getDimensionWidth() - 2;
        int innerLength = this.getDimensionLength() - 2;
        int innerHeight = this.getDimensionHeight() - 2;
        return new Vec3i(innerWidth, innerHeight, innerLength);
    }

    public Vec3i getDimension() {
        int width = this.getDimensionWidth();
        int length = this.getDimensionLength();
        int height = this.getDimensionHeight();
        return new Vec3i(width, height, length);
    }

    public int getDimensionWidth() {
        return ((IntSliderWidget)((Object)this.widthWidget.getSlider())).getValue();
    }

    public void setDimensionWidth(int width) {
        ((IntSliderWidget)((Object)this.widthWidget.getSlider())).setValue(width);
    }

    public abstract int getDimensionWidthMin();

    public abstract int getDimensionWidthMax();

    public int getDimensionLength() {
        return ((IntSliderWidget)((Object)this.lengthWidget.getSlider())).getValue();
    }

    public void setDimensionLength(int length) {
        ((IntSliderWidget)((Object)this.lengthWidget.getSlider())).setValue(length);
    }

    public abstract int getDimensionLengthMin();

    public abstract int getDimensionLengthMax();

    public int getDimensionHeight() {
        return ((IntSliderWidget)((Object)this.heightWidget.getSlider())).getValue();
    }

    public void seDimensionHeight(int height) {
        ((IntSliderWidget)((Object)this.heightWidget.getSlider())).setValue(height);
    }

    public abstract int getDimensionHeightMin();

    public abstract int getDimensionHeightMax();
}

