/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import giselle.jei_mekanism_multiblocks.client.GuiHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class CostWidget
extends AbstractWidget {
    private final ItemStack itemStack;
    private final boolean hasCountExpressionComponent;
    private final Component countExpressionComponent;
    private final Component countTotalComponent;
    private Component[] headTooltip;
    private Component[] tailTooltip;

    public CostWidget(int pX, int pY, int pWidth, int pHeight, ItemStack itemStack) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        this.itemStack = itemStack;
        this.packedFGColor = 0x3F3F3F;
        int count = itemStack.m_41613_();
        int maxStackSize = itemStack.m_41741_();
        int stacks = maxStackSize > 1 ? count / maxStackSize : 0;
        int remains = maxStackSize > 1 ? count % maxStackSize : 0;
        StringBuilder builder = new StringBuilder();
        if (stacks > 0) {
            builder.append(stacks).append("x").append(maxStackSize);
            if (remains > 0) {
                builder.append("+");
            }
        }
        if (remains > 0) {
            builder.append(remains);
        }
        this.hasCountExpressionComponent = stacks > 0;
        this.countExpressionComponent = Component.m_237113_((String)builder.toString());
        this.countTotalComponent = Component.m_237113_((String)"=").m_130946_(TextUtils.format((long)count));
        this.headTooltip = new Component[0];
        this.tailTooltip = new Component[0];
    }

    public void m_6303_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTicks) {
        Minecraft minecraft = Minecraft.m_91087_();
        ItemRenderer itemRenderer = minecraft.m_91291_();
        Font font = minecraft.f_91062_;
        Rect2i itemRect = this.getItemBounds();
        ItemStack itemStack = this.getItemStack();
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.m_123607_(pPoseStack.m_85850_().m_85861_());
        itemRenderer.m_174229_(null, itemStack, (int)vector4f.m_123601_() + itemRect.m_110085_(), (int)vector4f.m_123615_() + itemRect.m_110086_(), 0);
        int textX = itemRect.m_110085_() + 18;
        int textY = itemRect.m_110086_();
        int textWidth = this.f_93618_ - textX;
        int color = this.getFGColor();
        boolean shadow = false;
        if (this.hasCountExpressionComponent) {
            GuiHelper.drawScaledText(pPoseStack, this.countExpressionComponent, textX, textY, textWidth, color, shadow);
            Objects.requireNonNull(font);
            GuiHelper.drawScaledText(pPoseStack, this.countTotalComponent, textX, textY + 9, textWidth, color, shadow);
        } else {
            Objects.requireNonNull(font);
            GuiHelper.drawScaledText(pPoseStack, this.countTotalComponent, textX, textY + 9 / 2, textWidth, color, shadow);
        }
    }

    public void m_7428_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
        super.m_7428_(pPoseStack, pMouseX, pMouseY);
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ != null && this.f_93624_ && this.m_198029_()) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.addAll(Arrays.asList(this.getHeadTooltip()));
            tooltip.addAll(minecraft.f_91080_.m_96555_(this.getItemStack()));
            tooltip.addAll(Arrays.asList(this.getTailTooltip()));
            GuiHelper.renderComponentTooltip(pPoseStack, pMouseX, pMouseY, tooltip);
        }
    }

    public Rect2i getItemBounds() {
        int itemX = this.f_93620_ + 2;
        int itemY = this.f_93621_ + 2;
        return new Rect2i(itemX, itemY, 16, 16);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public Component[] getHeadTooltip() {
        return (Component[])this.headTooltip.clone();
    }

    public void setHeadTooltip(Component ... tooltip) {
        this.headTooltip = (Component[])tooltip.clone();
    }

    public Component[] getTailTooltip() {
        return (Component[])this.tailTooltip.clone();
    }

    public void setTailTooltip(Component ... tooltip) {
        this.tailTooltip = (Component[])tooltip.clone();
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

