/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.client.layer;

import com.blakebr0.ironjetpacks.compat.curios.CuriosCompat;
import com.blakebr0.ironjetpacks.item.JetpackItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class JetpackRenderLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("ironjetpacks", "textures/armor/jetpack.png");
    private static final ResourceLocation TEXTURE_OVERLAY = new ResourceLocation("ironjetpacks", "textures/armor/jetpack_overlay.png");

    public JetpackRenderLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack matrix, MultiBufferSource buffer, int lightness, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = entity.m_6844_(EquipmentSlot.CHEST);
        if (stack.m_41720_() instanceof JetpackItem) {
            return;
        }
        CuriosCompat.findJetpackCurio(entity, slot -> slot.slotContext().visible()).ifPresent(curio -> {
            HumanoidModel model = IClientItemExtensions.of((ItemStack)curio).getHumanoidArmorModel(entity, curio, EquipmentSlot.CHEST, null);
            ((HumanoidModel)this.m_117386_()).m_102872_(model);
            Item patt2175$temp = curio.m_41720_();
            if (patt2175$temp instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeable = (DyeableLeatherItem)patt2175$temp;
                int i = dyeable.m_41121_(curio);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                this.renderModel(matrix, buffer, lightness, curio.m_41790_(), (Model)model, r, g, b, TEXTURE);
                this.renderModel(matrix, buffer, lightness, curio.m_41790_(), (Model)model, 1.0f, 1.0f, 1.0f, TEXTURE_OVERLAY);
            } else {
                this.renderModel(matrix, buffer, lightness, curio.m_41790_(), (Model)model, 1.0f, 1.0f, 1.0f, TEXTURE);
            }
        });
    }

    private void renderModel(PoseStack matrix, MultiBufferSource buffer, int lightness, boolean foil, Model model, float r, float g, float b, ResourceLocation armorResource) {
        VertexConsumer vertex = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)foil);
        model.m_7695_(matrix, vertex, lightness, OverlayTexture.f_118083_, r, g, b, 1.0f);
    }
}

