/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.modcompat.commoncapabilities.BlockCapabilitiesHelpers;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.PositionedOperator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class PositionedOperatorRecipeHandler<T extends IValueType<V>, V extends IValue>
extends PositionedOperator {
    private final String unlocalizedType;

    public PositionedOperatorRecipeHandler(String name, Function function, IValueType output, DimPos pos, Direction side) {
        super(name, name, new IValueType[]{ValueTypes.OBJECT_INGREDIENTS}, output, function, IConfigRenderPattern.PREFIX_1, pos, side);
        this.unlocalizedType = "virtual";
        ((Function)this.getFunction()).setOperator(this);
    }

    public PositionedOperatorRecipeHandler(String name, Function function, DimPos pos, Direction side) {
        super(name, name, new IValueType[]{ValueTypes.OBJECT_INGREDIENTS}, ValueTypes.OBJECT_INGREDIENTS, function, IConfigRenderPattern.PREFIX_1, pos, side);
        this.unlocalizedType = "virtual";
        ((Function)this.getFunction()).setOperator(this);
    }

    protected LazyOptional<IRecipeHandler> getRecipeHandler() {
        return BlockCapabilitiesHelpers.getTileOrBlockCapability((DimPos)this.getPos(), (Direction)this.getSide(), Capabilities.RECIPE_HANDLER);
    }

    @Override
    protected String getUnlocalizedType() {
        return this.unlocalizedType;
    }

    @Override
    public IOperator materialize() {
        return this;
    }

    public static boolean validateIngredientsExact(IMixedIngredients ingredients, IMixedIngredients givenIngredients) {
        for (IngredientComponent component : ingredients.getComponents()) {
            List actualComponents = ingredients.getInstances(component);
            List givenComponents = givenIngredients.getInstances(component);
            if (actualComponents.size() != givenComponents.size()) {
                return false;
            }
            for (int i = 0; i < actualComponents.size(); ++i) {
                Object actualIngredient = actualComponents.get(i);
                Object givenIngredient = givenComponents.get(i);
                if (component.getMatcher().matchesExactly(givenIngredient, actualIngredient)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean validateIngredientsPartial(IMixedIngredients ingredients, IMixedIngredients givenIngredients) {
        for (IngredientComponent component : ingredients.getComponents()) {
            List actualComponents = ingredients.getInstances(component);
            List givenComponents = givenIngredients.getInstances(component);
            if (actualComponents.size() < givenComponents.size()) {
                return false;
            }
            LinkedList actualIndexBlacklist = Lists.newLinkedList();
            for (Object givenIngredient : givenComponents) {
                boolean match = false;
                for (int i = 0; i < actualComponents.size(); ++i) {
                    if (actualIndexBlacklist.contains(i) || !component.getMatcher().matchesExactly(givenIngredient, actualComponents.get(i))) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public static abstract class Function
    implements OperatorBase.IFunction {
        private PositionedOperatorRecipeHandler operator;

        public void setOperator(PositionedOperatorRecipeHandler operator) {
            this.operator = operator;
        }

        public PositionedOperatorRecipeHandler getOperator() {
            return this.operator;
        }
    }
}

