/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import flaxbeard.immersivepetroleum.api.crafting.DistillationTowerRecipe;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.util.RegistryUtils;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.compat.jei.IPRecipeCategory;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class DistillationRecipeCategory
extends IPRecipeCategory<DistillationTowerRecipe> {
    public static final ResourceLocation ID = ResourceUtils.ip("distillation");
    private final IDrawableStatic tankOverlay;

    public DistillationRecipeCategory(IGuiHelper guiHelper) {
        super(DistillationTowerRecipe.class, guiHelper, ID, "block.immersivepetroleum.distillation_tower");
        ResourceLocation background = ResourceUtils.ip("textures/gui/jei/distillationtower.png");
        this.setBackground(guiHelper.createDrawable(background, 0, 0, 120, 77));
        this.setIcon(new ItemStack((ItemLike)IPContent.Multiblock.DISTILLATIONTOWER.get()));
        this.tankOverlay = guiHelper.createDrawable(background, 120, 0, 20, 51);
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, DistillationTowerRecipe recipe, @Nonnull IFocusGroup focuses) {
        int outputTotal = 0;
        List list = recipe.getFluidOutputs();
        if (!list.isEmpty()) {
            for (FluidStack f : list) {
                outputTotal += f.getAmount();
            }
            int tW = 16;
            int tH = 47;
            int x0 = 47;
            int lastHeight = 52;
            for (int i = list.size() - 1; i >= 0; --i) {
                FluidStack f = (FluidStack)list.get(i);
                int height = (int)((float)tH * ((float)f.getAmount() / (float)outputTotal));
                IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, x0, lastHeight - height).setFluidRenderer((long)f.getAmount(), false, tW, height).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)f);
                lastHeight -= height;
                if (i != 0) continue;
                slot.setOverlay((IDrawable)this.tankOverlay, -2, -lastHeight + 3);
            }
        }
        if (recipe.getInputFluid() != null) {
            builder.addSlot(RecipeIngredientRole.INPUT, 11, 21).setFluidRenderer((long)outputTotal, false, 16, 47).setOverlay((IDrawable)this.tankOverlay, -2, -2).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, recipe.getInputFluid().getMatchingFluidStacks());
        }
        IRecipeSlotBuilder itemOutput = builder.addSlot(RecipeIngredientRole.OUTPUT, 77, 37).addTooltipCallback((IRecipeSlotTooltipCallback)new TooltipHandler(recipe));
        for (ItemStack s : recipe.getItemOutputs()) {
            itemOutput.addItemStack(s);
        }
    }

    public void draw(@Nonnull DistillationTowerRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull PoseStack matrix, double mouseX, double mouseY) {
        IDrawable background = this.getBackground();
        int bWidth = background.getWidth();
        int bHeight = background.getHeight();
        Font font = MCUtil.getFont();
        int time = recipe.getTotalProcessTime();
        int energy = recipe.getTotalProcessEnergy() / time;
        matrix.m_85836_();
        matrix.m_85837_(23.0, 0.0, 0.0);
        String text0 = I18n.m_118938_((String)"desc.immersiveengineering.info.ift", (Object[])new Object[]{Utils.fDecimal(energy)});
        float f = bWidth / 2 - font.m_92895_(text0) / 2;
        Objects.requireNonNull(font);
        font.m_92883_(matrix, text0, f, (float)(bHeight - 9 * 2), 0);
        String text1 = I18n.m_118938_((String)"desc.immersiveengineering.info.seconds", (Object[])new Object[]{Utils.fDecimal((double)time / 20.0)});
        float f2 = bWidth / 2 - font.m_92895_(text1) / 2;
        Objects.requireNonNull(font);
        font.m_92883_(matrix, text1, f2, (float)(bHeight - 9), 0);
        matrix.m_85849_();
    }

    private static class TooltipHandler
    implements IRecipeSlotTooltipCallback {
        private final Map<ResourceLocation, Double> map = new HashMap<ResourceLocation, Double>();

        public TooltipHandler(DistillationTowerRecipe recipe) {
            NonNullList list = recipe.getItemOutputs();
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = (ItemStack)list.get(i);
                this.map.put(RegistryUtils.getRegistryNameOf(stack.m_41720_()), recipe.chances()[i]);
            }
        }

        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            ItemStack stack;
            Double t;
            Object object;
            ITypedIngredient type = recipeSlotView.getDisplayedIngredient().orElse(null);
            if (type != null && (object = type.getIngredient()) instanceof ItemStack && (t = this.map.get(RegistryUtils.getRegistryNameOf((stack = (ItemStack)object).m_41720_()))) != null) {
                double chance = t;
                MutableComponent text = Component.m_237115_((String)"desc.immersivepetroleum.compat.jei.distillation.byproduct").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.UNDERLINE});
                tooltip.add(0, (Component)text);
                tooltip.add(2, this.toTextComponent(chance));
            }
        }

        private Component toTextComponent(double chance) {
            return Component.m_237113_((String)String.format(Locale.ENGLISH, "%.2f%%", 100.0 * chance)).m_130940_(ChatFormatting.GRAY);
        }
    }
}

