/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.network;

import flaxbeard.immersivepetroleum.common.entity.MotorboatEntity;
import flaxbeard.immersivepetroleum.common.network.INetMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MessageConsumeBoatFuel
implements INetMessage {
    public int amount;

    public MessageConsumeBoatFuel(int amount) {
        this.amount = amount;
    }

    public MessageConsumeBoatFuel(FriendlyByteBuf buf) {
        this.amount = buf.readInt();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.amount);
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity;
            NetworkEvent.Context con = (NetworkEvent.Context)context.get();
            if (con.getDirection().getReceptionSide() == LogicalSide.SERVER && con.getSender() != null && (entity = con.getSender().m_20202_()) instanceof MotorboatEntity) {
                MotorboatEntity boat = (MotorboatEntity)entity;
                FluidStack fluid = boat.getContainedFluid();
                if (fluid != null && fluid != FluidStack.EMPTY) {
                    fluid.setAmount(Math.max(0, fluid.getAmount() - this.amount));
                }
                boat.setContainedFluid(fluid);
            }
        });
    }
}

